/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.config.tree_grower;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class JTreeConfig
extends TreeConfiguration {
    public static final Codec<JTreeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").forGetter(p_161248_ -> p_161248_.trunkProvider), (App)TrunkPlacer.f_70262_.fieldOf("trunk_placer").forGetter(p_161246_ -> p_161246_.trunkPlacer), (App)BlockStateProvider.f_68747_.fieldOf("foliage_provider").forGetter(p_161244_ -> p_161244_.foliageProvider), (App)FoliagePlacer.f_68519_.fieldOf("foliage_placer").forGetter(p_191357_ -> p_191357_.foliagePlacer), (App)RootPlacer.f_225859_.optionalFieldOf("root_placer").forGetter(p_225478_ -> p_225478_.rootPlacer), (App)BlockStateProvider.f_68747_.fieldOf("dirt_provider").forGetter(p_225476_ -> p_225476_.dirtProvider), (App)FeatureSize.f_68281_.fieldOf("minimum_size").forGetter(p_225474_ -> p_225474_.minimumSize), (App)TreeDecorator.f_70021_.listOf().fieldOf("decorators").forGetter(p_225472_ -> p_225472_.decorators), (App)Codec.BOOL.fieldOf("ignore_vines").orElse((Object)false).forGetter(p_161232_ -> p_161232_.ignoreVines), (App)Codec.BOOL.fieldOf("force_dirt").orElse((Object)false).forGetter(p_225470_ -> p_225470_.forceDirt)).apply((Applicative)instance, JTreeConfig::new));
    public final BlockStateProvider trunkProvider;
    public final BlockStateProvider dirtProvider;
    public final TrunkPlacer trunkPlacer;
    public final BlockStateProvider foliageProvider;
    public final FoliagePlacer foliagePlacer;
    public final Optional<RootPlacer> rootPlacer;
    public final FeatureSize minimumSize;
    public final List<TreeDecorator> decorators;
    public final boolean ignoreVines;
    public final boolean forceDirt;

    public JTreeConfig(BlockStateProvider trunk, TrunkPlacer t, BlockStateProvider foiliage, FoliagePlacer fplacer, Optional<RootPlacer> rp, BlockStateProvider dirt, FeatureSize size, List<TreeDecorator> dec, boolean vines, boolean forceDirt) {
        super(trunk, t, foiliage, fplacer, rp, dirt, size, dec, vines, forceDirt);
        this.trunkProvider = trunk;
        this.trunkPlacer = t;
        this.foliageProvider = foiliage;
        this.foliagePlacer = fplacer;
        this.rootPlacer = rp;
        this.dirtProvider = dirt;
        this.minimumSize = size;
        this.decorators = dec;
        this.ignoreVines = vines;
        this.forceDirt = forceDirt;
    }

    public static class JTreeConfigurationBuilder {
        public final BlockStateProvider trunkProvider;
        private final TrunkPlacer trunkPlacer;
        public final BlockStateProvider foliageProvider;
        private final FoliagePlacer foliagePlacer;
        private final Optional<RootPlacer> rootPlacer;
        private BlockStateProvider dirtProvider;
        private final FeatureSize minimumSize;
        private List<TreeDecorator> decorators = ImmutableList.of();
        private boolean ignoreVines;
        private boolean forceDirt;

        public JTreeConfigurationBuilder(BlockStateProvider pTrunkProvider, TrunkPlacer pTrunkPlacer, BlockStateProvider pFoliageProvider, FoliagePlacer pFoliagePlacer, Optional<RootPlacer> pRootPlacer, FeatureSize pMinimumSize) {
            this.trunkProvider = pTrunkProvider;
            this.trunkPlacer = pTrunkPlacer;
            this.foliageProvider = pFoliageProvider;
            this.dirtProvider = BlockStateProvider.m_191382_((Block)Blocks.f_50493_);
            this.foliagePlacer = pFoliagePlacer;
            this.rootPlacer = pRootPlacer;
            this.minimumSize = pMinimumSize;
        }

        public JTreeConfigurationBuilder(BlockStateProvider pTrunkProvider, TrunkPlacer pTrunkPlacer, BlockStateProvider pFoliageProvider, FoliagePlacer pFoliagePlacer, FeatureSize pMinimumSize) {
            this(pTrunkProvider, pTrunkPlacer, pFoliageProvider, pFoliagePlacer, Optional.empty(), pMinimumSize);
        }

        public JTreeConfigurationBuilder dirt(BlockStateProvider pDirtProvider) {
            this.dirtProvider = pDirtProvider;
            return this;
        }

        public JTreeConfigurationBuilder decorators(List<TreeDecorator> pDecorators) {
            this.decorators = pDecorators;
            return this;
        }

        public JTreeConfigurationBuilder ignoreVines() {
            this.ignoreVines = true;
            return this;
        }

        public JTreeConfigurationBuilder forceDirt() {
            this.forceDirt = true;
            return this;
        }

        public JTreeConfig build() {
            return new JTreeConfig(this.trunkProvider, this.trunkPlacer, this.foliageProvider, this.foliagePlacer, this.rootPlacer, this.dirtProvider, this.minimumSize, this.decorators, this.ignoreVines, this.forceDirt);
        }
    }
}

