/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.world.feature.config.decoration.GemClusterConfig;
import divinerpg.world.placement.Surface;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.ForgeRegistries;

public class GemCluster
extends Feature<GemClusterConfig> {
    public GemCluster() {
        super(GemClusterConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<GemClusterConfig> context) {
        return this.place((GemClusterConfig)context.m_159778_(), context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_());
    }

    public boolean place(GemClusterConfig config, WorldGenLevel level, ChunkGenerator c, RandomSource random, BlockPos origin) {
        if (GemCluster.canBeHere(level, random, origin, config.rules)) {
            if (random.m_188501_() <= 0.2f) {
                this.m_5974_((LevelWriter)level, origin, config.buddingBlock);
                this.populateWithClusters(level, random, origin, config.cluster, 1.0f);
            } else if (random.m_188501_() <= 0.25f) {
                BlockState state = level.m_8055_(origin.m_7494_());
                if (Surface.hasSpace(state)) {
                    this.m_5974_((LevelWriter)level, origin.m_7494_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                } else {
                    state = level.m_8055_(origin.m_7495_());
                    if (Surface.hasSpace(state)) {
                        this.m_5974_((LevelWriter)level, origin.m_7495_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                    } else {
                        state = level.m_8055_(origin.m_122012_());
                        if (Surface.hasSpace(state)) {
                            this.m_5974_((LevelWriter)level, origin.m_122012_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                        } else {
                            state = level.m_8055_(origin.m_122019_());
                            if (Surface.hasSpace(state)) {
                                this.m_5974_((LevelWriter)level, origin.m_122019_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                            } else {
                                state = level.m_8055_(origin.m_122029_());
                                if (Surface.hasSpace(state)) {
                                    this.m_5974_((LevelWriter)level, origin.m_122029_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                                } else {
                                    state = level.m_8055_(origin.m_122024_());
                                    if (Surface.hasSpace(state)) {
                                        this.m_5974_((LevelWriter)level, origin.m_122024_(), (BlockState)((BlockState)config.cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                this.m_5974_((LevelWriter)level, origin, config.block);
                this.populateWithClusters(level, random, origin, config.cluster, 0.2f);
            }
            return true;
        }
        return false;
    }

    protected void populateWithClusters(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState cluster, float chance) {
        BlockState state = level.m_8055_(pos.m_7494_());
        if (Surface.hasSpace(state) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
        if (Surface.hasSpace(state = level.m_8055_(pos.m_7495_())) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_7495_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
        if (Surface.hasSpace(state = level.m_8055_(pos.m_122012_())) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_122012_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
        if (Surface.hasSpace(state = level.m_8055_(pos.m_122019_())) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_122019_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
        if (Surface.hasSpace(state = level.m_8055_(pos.m_122029_())) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_122029_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
        if (Surface.hasSpace(state = level.m_8055_(pos.m_122024_())) && (chance == 1.0f || random.m_188501_() <= chance)) {
            this.m_5974_((LevelWriter)level, pos.m_122024_(), (BlockState)((BlockState)cluster.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(state.m_60713_(Blocks.f_49990_))));
        }
    }

    public static boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, List<RuleTest> rules) {
        return GemCluster.rule(rules, random, level.m_8055_(pos)) && (Surface.hasSpace(level, pos.m_7494_()) || Surface.hasSpace(level, pos.m_7495_()) || Surface.hasSpace(level, pos.m_122012_()) || Surface.hasSpace(level, pos.m_122029_()) || Surface.hasSpace(level, pos.m_122019_()) || Surface.hasSpace(level, pos.m_122024_()));
    }

    public static boolean rule(List<RuleTest> rules, RandomSource random, BlockState state) {
        if (rules.isEmpty() && GemCluster.standardRule(state)) {
            return true;
        }
        for (RuleTest test : rules) {
            if (!test.m_213865_(state, random)) continue;
            return true;
        }
        return false;
    }

    public static boolean standardRule(BlockState state) {
        return state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_stone"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "cobbled_frozen_stone"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "gelidite"))) || state.m_204336_(BlockTags.f_13047_);
    }
}

