/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.DivineRPG;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowCoverage
extends Feature<NoneFeatureConfiguration> {
    public SnowCoverage() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(null, context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        int i = 0;
        for (int x = pos.m_123341_(); x < pos.m_123341_() + 16; ++x) {
            for (int z = pos.m_123343_(); z < pos.m_123343_() + 16; ++z) {
                i = (byte)(i + SnowCoverage.snow(level, random, new BlockPos.MutableBlockPos(x, Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.m_141937_(), level.m_151558_(), 0, level, random, x, z), z)));
            }
        }
        return i > 0;
    }

    public static boolean isWaterBlock(BlockState state) {
        return state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_50628_) || state.m_61145_((Property)BlockStateProperties.f_61362_).orElseGet(() -> false) != false || state.m_204336_(BlockTags.f_13050_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50038_);
    }

    public static byte snow(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos position) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache source = (ServerChunkCache)chunkSource;
            while (SnowCoverage.isWaterBlock(level.m_8055_((BlockPos)position))) {
                position.m_122184_(0, 1, 0);
            }
            DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(position.m_123341_(), position.m_123342_(), position.m_123343_());
            NoiseRouter router = source.m_214994_().m_224578_();
            double depth = (double)(((Biome)level.m_204166_((BlockPos)position).get()).getModifiedClimateSettings().f_47683_() + ((Biome)level.m_204166_(position.m_122012_()).get()).getModifiedClimateSettings().f_47683_() + ((Biome)level.m_204166_(position.m_122019_()).get()).getModifiedClimateSettings().f_47683_() + ((Biome)level.m_204166_(position.m_122029_()).get()).getModifiedClimateSettings().f_47683_() + ((Biome)level.m_204166_(position.m_122024_()).get()).getModifiedClimateSettings().f_47683_()) / 5.0 * (router.f_224392_().m_207386_((DensityFunction.FunctionContext)context) + 1.1) + router.f_209384_().m_207386_((DensityFunction.FunctionContext)context) + 1.0;
            if (depth >= 0.125) {
                BlockPos below = position.m_7495_();
                BlockState state = level.m_8055_(below);
                if (SnowCoverage.isWaterBlock(state)) {
                    level.m_7731_(below, Blocks.f_50126_.m_49966_(), 3);
                } else {
                    if (state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_152499_) || state.m_204336_(BlockTags.f_13047_) || !state.m_60838_((BlockGetter)level, below)) {
                        return 0;
                    }
                    if (state.m_204336_(BlockTags.f_13035_)) {
                        depth -= 0.2;
                    }
                    if (state.m_61138_((Property)BlockStateProperties.f_61451_)) {
                        BlockPos.MutableBlockPos p = below.m_122032_();
                        SnowCoverage.snowLog(level, p, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)), new boolean[]{level.m_8055_(p.m_122012_()).m_60795_(), level.m_8055_(p.m_122019_()).m_60795_(), level.m_8055_(p.m_122029_()).m_60795_(), level.m_8055_(p.m_122024_()).m_60795_()});
                    }
                    if (depth >= 1.0) {
                        if (depth >= 2.0) {
                            depth = Math.floor(depth);
                            state = random.m_188501_() < 0.94f ? Blocks.f_152499_.m_49966_() : Blocks.f_50127_.m_49966_();
                        } else {
                            state = Blocks.f_50127_.m_49966_();
                        }
                        int k = (int)depth;
                        for (int i = 0; i < k; ++i) {
                            if (!level.m_8055_((BlockPos)position).m_60795_()) continue;
                            level.m_7731_((BlockPos)position, state, 3);
                            position.m_122184_(0, 1, 0);
                        }
                        depth -= (double)k;
                    }
                    if (depth >= 0.125 && !state.m_60713_(Blocks.f_152499_) && level.m_8055_((BlockPos)position).m_60795_()) {
                        level.m_7731_((BlockPos)position, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf((int)(depth * 8.0))), 3);
                    }
                }
                return 1;
            }
        } else {
            DivineRPG.LOGGER.info("could not access server chunk cache");
        }
        return 0;
    }

    static void snowLog(WorldGenLevel level, BlockPos.MutableBlockPos pos, BlockState snowyBlock, boolean[] space) {
        BlockState nextState;
        level.m_7731_((BlockPos)pos, snowyBlock, 2);
        pos.m_122184_(0, -1, 0);
        if (space[0] && !level.m_8055_(pos.m_122012_()).m_60795_()) {
            space[0] = false;
        }
        if (space[1] && !level.m_8055_(pos.m_122019_()).m_60795_()) {
            space[1] = false;
        }
        if (space[2] && !level.m_8055_(pos.m_122029_()).m_60795_()) {
            space[2] = false;
        }
        if (space[3] && !level.m_8055_(pos.m_122024_()).m_60795_()) {
            space[3] = false;
        }
        if ((space[0] || space[1] || space[2] || space[3]) && (nextState = level.m_8055_((BlockPos)pos)).m_60713_(snowyBlock.m_60734_())) {
            SnowCoverage.snowLog(level, pos, (BlockState)nextState.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)), space);
        }
    }
}

