/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class FractalTree
extends DivineTree {
    protected Vec3 pos = null;
    protected Vec3 left = null;
    protected Vec3 right = null;
    protected Vec3 upright = null;
    protected Vec3 downright = null;
    protected Vec3 downleft = null;
    protected Vec3 upleft = null;
    protected Vec3 current = null;

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_) || state.m_204336_(BlockTags.f_13047_) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_grass"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_dirt")));
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            boolean treeType;
            int treeHeight;
            if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144279_)) {
                pos = pos.m_7495_();
            }
            if (this.heightCheck(level, pos, treeHeight = ((treeType = random.m_188499_() ? true : random.m_188499_()) ? 4 : 6) + random.m_188503_(5), 1)) {
                BlockState packed_ice = config.log;
                this.grow(level, pos, packed_ice, treeHeight, true);
                BlockPos.MutableBlockPos position = pos.m_122032_();
                if (treeType) {
                    int shift = random.m_188503_(2);
                    boolean rotation = random.m_188499_();
                    boolean longBranches = random.m_188499_();
                    for (int y = 0; y < treeHeight; ++y) {
                        if (y % 2 == shift) {
                            boolean turned = random.m_188499_();
                            BlockState state = this.getState(config, turned);
                            if (rotation) {
                                this.setBlock(level, position.m_122012_(), state, false);
                                this.setBlock(level, position.m_122019_(), state, false);
                                if (!turned) {
                                    turned = random.m_188499_();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.m_122013_(2).m_7494_(), state, false);
                                this.setBlock(level, position.m_122020_(2).m_7494_(), state, false);
                                if (!turned) {
                                    turned = random.m_188499_();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.m_122013_(3).m_6630_(2), state, false);
                                this.setBlock(level, position.m_122020_(3).m_6630_(2), state, false);
                                if (longBranches) {
                                    if (!turned) {
                                        turned = random.m_188499_();
                                        state = this.getState(config, turned);
                                    }
                                    this.setBlock(level, position.m_122013_(4).m_6630_(3), state, false);
                                    this.setBlock(level, position.m_122020_(4).m_6630_(3), state, false);
                                }
                            } else {
                                this.setBlock(level, position.m_122029_(), state, false);
                                this.setBlock(level, position.m_122024_(), state, false);
                                if (!turned) {
                                    turned = random.m_188499_();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.m_122030_(2).m_7494_(), state, false);
                                this.setBlock(level, position.m_122025_(2).m_7494_(), state, false);
                                if (!turned) {
                                    turned = random.m_188499_();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.m_122030_(3).m_6630_(2), state, false);
                                this.setBlock(level, position.m_122025_(3).m_6630_(2), state, false);
                                if (longBranches) {
                                    if (!turned) {
                                        turned = random.m_188499_();
                                        state = this.getState(config, turned);
                                    }
                                    this.setBlock(level, position.m_122030_(4).m_6630_(3), state, false);
                                    this.setBlock(level, position.m_122025_(4).m_6630_(3), state, false);
                                }
                            }
                            rotation = !rotation;
                        }
                        position.m_122184_(0, 1, 0);
                    }
                } else if (random.m_188499_()) {
                    int shift = random.m_188503_(2);
                    boolean rotation = random.m_188499_();
                    for (int y = 0; y < treeHeight; ++y) {
                        if (y % 2 == shift) {
                            BlockState state = this.getState(config, random.m_188499_());
                            if (rotation) {
                                this.setBlock(level, position.m_122012_(), state, false);
                                this.setBlock(level, position.m_122019_(), state, false);
                            } else {
                                this.setBlock(level, position.m_122029_(), state, false);
                                this.setBlock(level, position.m_122024_(), state, false);
                            }
                            rotation = !rotation;
                        }
                        position.m_122184_(0, 1, 0);
                    }
                } else {
                    position.m_122184_(0, treeHeight, 0);
                    for (int i = 0; i < 3; ++i) {
                        position.m_122184_(0, -2, 0);
                        for (BlockPos p : this.fullSnowflake((BlockPos)position, (double)treeHeight / ((double)i + 0.9), 2)) {
                            this.setBlock(level, p, this.getState(config, random.m_188499_()), false);
                        }
                        this.grow(level, (BlockPos)position, this.getState(config, random.m_188499_()), 1, 1);
                        if (i >= 2) continue;
                        this.grow(level, (BlockPos)position, this.getState(config, random.m_188499_()), 2, 2);
                        if (i != 0) continue;
                        this.grow(level, (BlockPos)position, this.getState(config, random.m_188499_()), 3, 3);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected BlockState getState(TreeConfig config, boolean b) {
        return b ? config.leaves : config.log;
    }

    protected ArrayList<BlockPos> fullSnowflake(BlockPos center, double size, int detail) {
        this.pos = center.m_252807_().m_82520_(-size / 1.55, 0.0, -size / 3.0);
        this.left = new Vec3(-1.0, 0.0, 0.0);
        this.right = new Vec3(1.0, 0.0, 0.0);
        this.upright = new Vec3(0.5, 0.0, Math.sqrt(3.0) / 2.0);
        this.downright = new Vec3(0.5, 0.0, -Math.sqrt(3.0) / 2.0);
        this.downleft = new Vec3(-0.5, 0.0, -Math.sqrt(3.0) / 2.0);
        this.upleft = new Vec3(-0.5, 0.0, Math.sqrt(3.0) / 2.0);
        this.current = this.upright;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        this.snowflake(result, size, detail);
        this.turnRight();
        this.snowflake(result, size, detail);
        this.turnRight();
        this.snowflake(result, size, detail);
        return result;
    }

    protected void snowflake(ArrayList<BlockPos> map, double sideLength, int level) {
        if (level == 0) {
            Vec3 movement = this.current.m_82542_(sideLength, 0.0, sideLength);
            if (movement.f_82479_ >= 1.0 || movement.f_82481_ >= 1.0) {
                BlockPos position;
                int steps = (int)(movement.f_82479_ > movement.f_82481_ ? movement.f_82479_ * 2.0 : movement.f_82481_ * 2.0);
                Vec3 step = new Vec3(movement.f_82479_ / (double)steps, 0.0, movement.f_82481_ / (double)steps);
                for (int i = 0; i < steps; ++i) {
                    position = new BlockPos((int)this.pos.f_82479_, (int)this.pos.f_82480_, (int)this.pos.f_82481_);
                    if (!map.contains(position)) {
                        map.add(position);
                    }
                    this.pos = this.pos.m_82549_(step);
                }
                position = new BlockPos((int)this.pos.f_82479_, (int)this.pos.f_82480_, (int)this.pos.f_82481_);
                if (!map.contains(position)) {
                    map.add(position);
                }
            } else {
                BlockPos position = new BlockPos((int)this.pos.f_82479_, (int)this.pos.f_82480_, (int)this.pos.f_82481_);
                if (!map.contains(position)) {
                    map.add(position);
                }
                this.pos = this.pos.m_82549_(movement);
                position = new BlockPos((int)this.pos.f_82479_, (int)this.pos.f_82480_, (int)this.pos.f_82481_);
                if (!map.contains(position)) {
                    map.add(position);
                }
            }
        } else {
            this.snowflake(map, sideLength /= 3.0, --level);
            this.turnLeft();
            this.snowflake(map, sideLength, level);
            this.turnRight();
            this.snowflake(map, sideLength, level);
            this.turnLeft();
            this.snowflake(map, sideLength, level);
        }
    }

    protected void turnLeft() {
        this.current = this.current.equals((Object)this.right) ? this.upright : (this.current.equals((Object)this.upright) ? this.upleft : (this.current.equals((Object)this.upleft) ? this.left : (this.current.equals((Object)this.left) ? this.downleft : (this.current.equals((Object)this.downleft) ? this.downright : this.right))));
    }

    protected void turnRight() {
        this.current = this.current.equals((Object)this.right) ? this.downleft : (this.current.equals((Object)this.downleft) ? this.upleft : (this.current.equals((Object)this.upleft) ? this.right : (this.current.equals((Object)this.left) ? this.upright : (this.current.equals((Object)this.upright) ? this.downright : this.left))));
    }
}

