/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.SkythernTree;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class ShiverspineTree
extends SkythernTree {
    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_grass"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_dirt")));
    }

    @Override
    public boolean hasSpace(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_) || super.hasSpace(state);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int extraHeight2;
            int treeHeight;
            if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144279_)) {
                pos = pos.m_7495_();
            }
            int treeType = random.m_188503_(11);
            int width = 1;
            switch (treeType) {
                case 1: 
                case 2: {
                    treeHeight = 3 + random.m_188503_(6);
                    extraHeight2 = treeHeight + 3;
                    break;
                }
                case 0: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    width = 2;
                    int treeHeight2 = 15 + random.m_188503_(20);
                    int extraHeight2 = treeHeight2 + 2;
                }
                default: {
                    return super.place(config, level, chunkGen, random, pos);
                }
            }
            if (this.heightCheck(level, pos, extraHeight2, width)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                this.grow(level, pos.m_7495_(), log, treeHeight + 1);
                this.grow(level, pos.m_7918_(0, treeHeight + 1, 0), leaves, extraHeight2 - 1 - treeHeight);
                if (width == 2) {
                    this.grow(level, pos.m_7918_(1, -1, 0), log, treeHeight + 1);
                    this.grow(level, pos.m_7918_(1, treeHeight + 1, 0), leaves, extraHeight2 - 1 - treeHeight);
                    this.grow(level, pos.m_7918_(0, -1, 1), log, treeHeight - 1);
                    this.grow(level, pos.m_7918_(0, treeHeight + 1, 1), leaves, extraHeight2 - 1 - treeHeight);
                    this.grow(level, pos.m_7918_(1, -1, 1), log, treeHeight + 1);
                    this.grow(level, pos.m_7918_(1, treeHeight + 1, 1), leaves, extraHeight2 - 1 - treeHeight);
                }
                switch (treeType) {
                    case 1: 
                    case 2: {
                        int bottomHeight = random.m_188503_(2);
                        int wideHeight = 2 - bottomHeight + random.m_188503_(2);
                        boolean shift = random.m_188499_();
                        boolean even = treeHeight % 2 == bottomHeight ^ shift;
                        for (int y = 2 - bottomHeight; y <= treeHeight; ++y) {
                            BlockPos temp;
                            if (y == wideHeight && treeType == 2 && wideHeight != extraHeight2 - 3) {
                                temp = pos.m_7918_(0, y, 0);
                                this.grow(level, temp, leaves, 1, 1);
                                this.grow(level, temp, leaves, 2, -1);
                                this.grow(level, temp, leaves, 2, 0);
                                this.grow(level, temp, leaves, 2, 1);
                                this.grow(level, temp, leaves, 2, 2);
                                for (int offset = -2; offset < 3; ++offset) {
                                    this.grow(level, temp, leaves, 3, offset);
                                }
                                if (!(y % 2 == bottomHeight ^ shift)) continue;
                                shift = !shift;
                                continue;
                            }
                            if (!(y % 2 == bottomHeight ^ shift)) continue;
                            temp = pos.m_7918_(0, y, 0);
                            this.grow(level, temp, leaves, 1, 1);
                            this.grow(level, temp, leaves, 2, -1);
                            this.grow(level, temp, leaves, 2, 0);
                            this.grow(level, temp, leaves, 2, 1);
                        }
                        this.grow(level, pos.m_7918_(0, treeHeight, 0), log, random.m_188503_(even ? 2 : 3));
                        this.grow(level, pos.m_7918_(0, 2 - bottomHeight, 0), leaves, treeHeight + (even ? -1 : -2) + bottomHeight, 1, 0);
                        this.grow(level, pos.m_7918_(0, extraHeight2 - (even ? 0 : 1), 0), leaves, 1, 0);
                        break;
                    }
                    case 7: 
                    case 8: {
                        BlockPos temp = pos.m_7918_(0, treeHeight + 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 1);
                        int bottomHeight = 2 + random.m_188503_(5);
                        temp = pos.m_7918_(0, bottomHeight, 0);
                        int tempInt = --treeHeight - bottomHeight;
                        this.wideGrow(level, temp, leaves, tempInt, 1, 0);
                        this.wideGrow(level, temp, leaves, tempInt, 1, 1);
                        for (width = treeHeight - 1; width > bottomHeight; --width) {
                            int offset;
                            if ((treeHeight - width) % 3 != 0) {
                                this.wideGrow(level, pos.m_7918_(0, width, 0), leaves, 1, -1);
                                for (offset = -1; offset < 3; ++offset) {
                                    this.wideGrow(level, pos.m_7918_(0, width, 0), leaves, 2, offset);
                                }
                            }
                            if ((treeHeight - width) % 3 != 2) continue;
                            this.wideGrow(level, pos.m_7918_(0, width, 0), leaves, 2, -2);
                            for (offset = -2; offset < 4; ++offset) {
                                this.wideGrow(level, pos.m_7918_(0, width, 0), leaves, 3, offset);
                            }
                        }
                        break;
                    }
                    default: {
                        BlockPos temp = pos.m_7918_(0, extraHeight2, 0);
                        this.wideGrow(level, temp, leaves, 1, 0);
                        this.wideGrow(level, temp, leaves, 1, 1);
                        int bottomHeight = 5 + random.m_188503_(10);
                        ++treeHeight;
                        int stage = 2;
                        while (treeHeight > bottomHeight) {
                            for (width = 1; width < stage; ++width) {
                                extraHeight2 = --treeHeight + 1 - (stage - width);
                                for (int offset = 1 - width; offset <= width; ++offset) {
                                    this.wideGrow(level, pos.m_7918_(0, extraHeight2, 0), leaves, treeHeight - extraHeight2, width, offset);
                                }
                                this.wideGrow(level, pos.m_7918_(0, extraHeight2, 0), leaves, treeHeight - extraHeight2, width - 1, width);
                            }
                            if (stage >= 6) continue;
                            ++stage;
                        }
                        break block4;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

