/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Guardian;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.config.EMFConfigScreenDebugLogOptions;
import traben.entity_model_features.config.EMFConfigScreenOptions;
import traben.entity_model_features.config.EMFConfigScreenTools;
import traben.entity_texture_features.config.screens.ETFConfigScreen;

public class EMFConfigScreenMain
extends ETFConfigScreen {
    private final Random rand = new Random();
    public EMFConfig tempConfig = EMFConfig.copyFrom(EMFConfig.getConfig());
    private long timer = 0L;
    private LivingEntity livingEntity = null;

    public EMFConfigScreenMain(Screen parent) {
        super((Component)Component.m_237115_((String)"entity_model_features.title"), parent);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            if (!this.tempConfig.equals(EMFConfig.getConfig())) {
                EMFConfig.setConfig(this.tempConfig);
                EMFConfig.EMF_saveConfig();
                Minecraft.m_91087_().m_91391_();
            }
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }).m_252987_((int)((double)this.f_96543_ * 0.7), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"dataPack.validation.reset"), button -> {
            this.tempConfig = new EMFConfig();
            this.m_232761_();
        }).m_252987_((int)((double)this.f_96543_ * 0.4), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.22), 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            this.tempConfig = null;
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }).m_252987_((int)((double)this.f_96543_ * 0.1), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20).m_253136_());
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.6), (int)((double)this.f_96544_ * 0.2), (int)((double)this.f_96543_ * 0.3), 20, (Component)Component.m_237115_((String)"entity_model_features.config.options"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new EMFConfigScreenOptions(this)), (Component)Component.m_237115_((String)"entity_model_features.config.options.tooltip")));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.6), (int)((double)this.f_96544_ * 0.3), (int)((double)this.f_96543_ * 0.3), 20, (Component)Component.m_237115_((String)"entity_model_features.config.tools"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new EMFConfigScreenTools(this)), (Component)Component.m_237115_((String)"entity_model_features.config.tools.tooltip")));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.6), (int)((double)this.f_96544_ * 0.4), (int)((double)this.f_96543_ * 0.3), 20, (Component)Component.m_237115_((String)"entity_model_features.config.debug"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new EMFConfigScreenDebugLogOptions(this)), (Component)Component.m_237115_((String)"entity_model_features.config.debug.tooltip")));
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.timer + 5000L < System.currentTimeMillis() && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_9236_() != null) {
            List entityList = Minecraft.m_91087_().f_91074_.m_9236_().m_45933_(null, Minecraft.m_91087_().f_91074_.m_20191_().m_82400_(128.0));
            Entity entity = null;
            for (int i = 0; i < Math.min(entityList.size(), 24) && !((entity = (Entity)entityList.get(this.rand.nextInt(entityList.size()))) instanceof LivingEntity); ++i) {
            }
            if (entity instanceof LivingEntity) {
                this.livingEntity = (LivingEntity)entity;
                this.timer = System.currentTimeMillis();
            }
        }
        if (this.livingEntity != null && !this.livingEntity.m_213877_()) {
            double scale;
            int y = (int)((double)this.f_96544_ * 0.75);
            if ((double)this.livingEntity.m_20206_() < 0.7) {
                y -= (int)((double)this.f_96544_ * 0.15);
            }
            int x = (int)((double)this.f_96543_ * 0.33);
            float g = (float)Math.atan(((float)(-mouseY) + (float)this.f_96544_ / 2.0f) / 40.0f);
            Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)System.currentTimeMillis() / 1000.0 % (Math.PI * 2)));
            Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)));
            quaternionf.mul((Quaternionfc)quaternionf2);
            double autoScale = (double)this.f_96544_ * 0.4 / (double)Math.max(1.0f, Math.max(this.livingEntity.m_20206_(), this.livingEntity.m_20205_()));
            if (this.livingEntity instanceof Squid) {
                y -= (int)((double)this.f_96544_ * 0.15);
                scale = autoScale * 0.5;
            } else if (this.livingEntity instanceof Guardian || this.livingEntity instanceof Sniffer) {
                y -= (int)((double)this.f_96544_ * 0.1);
                scale = autoScale * 0.7;
            } else if (this.livingEntity instanceof EnderDragon) {
                y -= (int)((double)this.f_96544_ * 0.15);
                scale = autoScale * 1.5;
            } else {
                scale = autoScale;
            }
            double scaleModify = Math.sin((double)(System.currentTimeMillis() - this.timer) / 5000.0 * Math.PI) * 6.0;
            double scaleModify2 = Math.max(Math.min(Math.abs(scaleModify), 1.0), 0.0);
            int modelHeight = (int)Math.min(scale * scaleModify2, (double)this.f_96544_ * 0.4);
            context.m_280168_().m_85836_();
            context.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
            InventoryScreen.m_280432_((GuiGraphics)context, (int)x, (int)y, (int)modelHeight, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (LivingEntity)this.livingEntity);
            context.m_280168_().m_85849_();
        } else {
            context.m_280653_(this.f_96547_, Component.m_130674_((String)"Load a world and nearby entities will appear here."), this.f_96543_ / 3, this.f_96544_ / 2, Color.GRAY.getRGB());
        }
    }

    public void m_280039_(GuiGraphics context) {
        super.m_280039_(context);
    }
}

