/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.CuboidAccessor;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFUtils;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartCustom
extends EMFModelPart {
    public final String partToBeAttached;
    public final String id;
    public final boolean attach;

    public EMFModelPartCustom(EMFPartData emfPartData, int variant, @Nullable String part, String id) {
        super(EMFModelPartCustom.getCuboidsFromData(emfPartData), EMFModelPartCustom.getChildrenFromData(emfPartData, variant));
        this.attach = emfPartData.attach;
        this.partToBeAttached = part;
        this.id = id;
        this.textureOverride = emfPartData.customTexture;
        this.f_233553_ = emfPartData.scale;
        this.f_233554_ = emfPartData.scale;
        this.f_233555_ = emfPartData.scale;
        this.f_104200_ = emfPartData.translate[0];
        this.f_104201_ = emfPartData.translate[1];
        this.f_104202_ = emfPartData.translate[2];
        this.f_104203_ = emfPartData.rotate[0];
        this.f_104204_ = emfPartData.rotate[1];
        this.f_104205_ = emfPartData.rotate[2];
        this.m_233560_(this.m_171308_());
        if (EMFConfig.getConfig().logModelCreationData) {
            System.out.println(" > > EMF custom part made: " + emfPartData.id);
        }
    }

    private static List<ModelPart.Cube> getCuboidsFromData(EMFPartData emfPartData) {
        return EMFModelPartCustom.createCuboidsFromBoxDataV3(emfPartData);
    }

    private static Map<String, ModelPart> getChildrenFromData(EMFPartData emfPartData, int variant) {
        HashMap<String, ModelPart> emfChildren = new HashMap<String, ModelPart>();
        for (EMFPartData sub : emfPartData.submodels) {
            String idUnique = EMFUtils.getIdUnique(emfChildren.keySet(), sub.id);
            emfChildren.put(idUnique, new EMFModelPartCustom(sub, variant, null, idUnique));
        }
        return emfChildren;
    }

    private static List<ModelPart.Cube> createCuboidsFromBoxDataV3(EMFPartData emfPartData) {
        LinkedList<ModelPart.Cube> emfCuboids = new LinkedList<ModelPart.Cube>();
        if (emfPartData.boxes.length > 0) {
            try {
                for (EMFBoxData box : emfPartData.boxes) {
                    ModelPart.Cube cube = box.textureOffset.length == 2 ? EMFModelPartCustom.emfCuboidOf(emfPartData, box.textureOffset[0], box.textureOffset[1], box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v")) : EMFModelPartCustom.emfCuboidOf(emfPartData, box.uvDown, box.uvUp, box.uvNorth, box.uvSouth, box.uvWest, box.uvEast, box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v"));
                    emfCuboids.add(cube);
                }
            }
            catch (Exception e) {
                EMFUtils.log("cuboid construction broke: " + e, false);
            }
        }
        return emfCuboids;
    }

    @Override
    public String toString() {
        return "[custom part " + this.id + "], cubes =" + this.f_104212_.size() + ", children = " + this.f_104213_.size();
    }

    @Override
    public String toStringShort() {
        return "[custom part " + this.id.replaceFirst("EMF_", "") + "]";
    }

    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        switch (EMFConfig.getConfig().renderModeChoice) {
            case NORMAL: {
                super.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                break;
            }
            case GREEN: {
                float flash = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
                super.renderWithTextureOverride(matrices, vertices, light, overlay, flash, green, flash, alpha);
                break;
            }
            case LINES: {
                this.renderBoxes(matrices, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()));
                break;
            }
        }
    }

    public static ModelPart.Cube emfCuboidOf(EMFPartData selfModelData, float textureU, float textureV, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
        ArrayList<ModelPart.Polygon> sides;
        ModelPart.Cube cube;
        block25: {
            float r;
            float q;
            float o;
            float n;
            ModelPart.Vertex vertex8;
            ModelPart.Vertex vertex7;
            ModelPart.Vertex vertex6;
            ModelPart.Vertex vertex5;
            block24: {
                float l;
                ModelPart.Vertex vertex4;
                ModelPart.Vertex vertex3;
                ModelPart.Vertex vertex2;
                ModelPart.Vertex vertex;
                block23: {
                    float k;
                    block22: {
                        float j;
                        block21: {
                            float p;
                            float m;
                            block20: {
                                cube = new ModelPart.Cube((int)textureU, (int)textureV, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<Direction>(){
                                    {
                                        this.addAll(List.of(Direction.values()));
                                    }
                                });
                                CuboidAccessor accessor = (CuboidAccessor)cube;
                                accessor.setMinX(cubeX);
                                accessor.setMinY(cubeY);
                                accessor.setMinZ(cubeZ);
                                accessor.setMaxX(cubeX + sizeX);
                                accessor.setMaxY(cubeY + sizeY);
                                accessor.setMaxZ(cubeZ + sizeZ);
                                sides = new ArrayList<ModelPart.Polygon>();
                                float cubeX2 = cubeX + sizeX;
                                float cubeY2 = cubeY + sizeY;
                                float cubeZ2 = cubeZ + sizeZ;
                                vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                j = textureU;
                                k = textureU + sizeZ;
                                l = textureU + sizeZ + sizeX;
                                m = textureU + sizeZ + sizeX + sizeX;
                                n = textureU + sizeZ + sizeX + sizeZ;
                                o = textureU + sizeZ + sizeX + sizeZ + sizeX;
                                p = textureV;
                                q = textureV + sizeZ;
                                r = textureV + sizeZ + sizeY;
                                try {
                                    ModelPart.Vertex[] vertexArray;
                                    if (mirrorV) {
                                        ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                                        vertexArray2[0] = vertex3;
                                        vertexArray2[1] = vertex4;
                                        vertexArray2[2] = vertex8;
                                        vertexArray = vertexArray2;
                                        vertexArray2[3] = vertex7;
                                    } else {
                                        ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                                        vertexArray3[0] = vertex6;
                                        vertexArray3[1] = vertex5;
                                        vertexArray3[2] = vertex;
                                        vertexArray = vertexArray3;
                                        vertexArray3[3] = vertex2;
                                    }
                                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? l : k, mirrorV ? q : p, mirrorU ? k : l, mirrorV ? p : q, textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().logModelCreationData) break block20;
                                    EMFUtils.log("uv-dwn failed for " + selfModelData.id);
                                }
                            }
                            try {
                                ModelPart.Vertex[] vertexArray;
                                if (mirrorV) {
                                    ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                                    vertexArray4[0] = vertex6;
                                    vertexArray4[1] = vertex5;
                                    vertexArray4[2] = vertex;
                                    vertexArray = vertexArray4;
                                    vertexArray4[3] = vertex2;
                                } else {
                                    ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                                    vertexArray5[0] = vertex3;
                                    vertexArray5[1] = vertex4;
                                    vertexArray5[2] = vertex8;
                                    vertexArray = vertexArray5;
                                    vertexArray5[3] = vertex7;
                                }
                                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? m : l, mirrorV ? p : q, mirrorU ? l : m, mirrorV ? q : p, textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().logModelCreationData) break block21;
                                EMFUtils.log("uv-up failed for " + selfModelData.id);
                            }
                        }
                        try {
                            ModelPart.Vertex[] vertexArray;
                            if (mirrorU) {
                                ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                                vertexArray6[0] = vertex6;
                                vertexArray6[1] = vertex2;
                                vertexArray6[2] = vertex3;
                                vertexArray = vertexArray6;
                                vertexArray6[3] = vertex7;
                            } else {
                                ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                                vertexArray7[0] = vertex;
                                vertexArray7[1] = vertex5;
                                vertexArray7[2] = vertex8;
                                vertexArray = vertexArray7;
                                vertexArray7[3] = vertex4;
                            }
                            sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? k : j, mirrorV ? r : q, mirrorU ? j : k, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().logModelCreationData) break block22;
                            EMFUtils.log("uv-west failed for " + selfModelData.id);
                        }
                    }
                    try {
                        sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? l : k, mirrorV ? r : q, mirrorU ? k : l, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.NORTH));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().logModelCreationData) break block23;
                        EMFUtils.log("uv-nrth failed for " + selfModelData.id);
                    }
                }
                try {
                    ModelPart.Vertex[] vertexArray;
                    if (mirrorU) {
                        ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                        vertexArray8[0] = vertex;
                        vertexArray8[1] = vertex5;
                        vertexArray8[2] = vertex8;
                        vertexArray = vertexArray8;
                        vertexArray8[3] = vertex4;
                    } else {
                        ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                        vertexArray9[0] = vertex6;
                        vertexArray9[1] = vertex2;
                        vertexArray9[2] = vertex3;
                        vertexArray = vertexArray9;
                        vertexArray9[3] = vertex7;
                    }
                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? n : l, mirrorV ? r : q, mirrorU ? l : n, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().logModelCreationData) break block24;
                    EMFUtils.log("uv-east failed for " + selfModelData.id);
                }
            }
            try {
                sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? o : n, mirrorV ? r : q, mirrorU ? n : o, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.SOUTH));
            }
            catch (Exception e) {
                if (!EMFConfig.getConfig().logModelCreationData) break block25;
                EMFUtils.log("uv-sth failed for " + selfModelData.id);
            }
        }
        ((CuboidAccessor)cube).setSides(sides.toArray(new ModelPart.Polygon[0]));
        return cube;
    }

    public static ModelPart.Cube emfCuboidOf(EMFPartData selfModelData, float[] uvDown, float[] uvUp, float[] uvNorth, float[] uvSouth, float[] uvWest, float[] uvEast, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
        ArrayList<ModelPart.Polygon> sides;
        ModelPart.Cube cube;
        block25: {
            ModelPart.Vertex vertex8;
            ModelPart.Vertex vertex7;
            ModelPart.Vertex vertex6;
            ModelPart.Vertex vertex5;
            block24: {
                ModelPart.Vertex vertex4;
                ModelPart.Vertex vertex3;
                ModelPart.Vertex vertex2;
                ModelPart.Vertex vertex;
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                cube = new ModelPart.Cube(0, 0, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<Direction>(){
                                    {
                                        this.addAll(List.of(Direction.values()));
                                    }
                                });
                                CuboidAccessor accessor = (CuboidAccessor)cube;
                                accessor.setMinX(cubeX);
                                accessor.setMinY(cubeY);
                                accessor.setMinZ(cubeZ);
                                accessor.setMaxX(cubeX + sizeX);
                                accessor.setMaxY(cubeY + sizeY);
                                accessor.setMaxZ(cubeZ + sizeZ);
                                sides = new ArrayList<ModelPart.Polygon>();
                                float cubeX2 = cubeX + sizeX;
                                float cubeY2 = cubeY + sizeY;
                                float cubeZ2 = cubeZ + sizeZ;
                                vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                try {
                                    ModelPart.Vertex[] vertexArray;
                                    if (mirrorV) {
                                        ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                                        vertexArray2[0] = vertex8;
                                        vertexArray2[1] = vertex7;
                                        vertexArray2[2] = vertex3;
                                        vertexArray = vertexArray2;
                                        vertexArray2[3] = vertex4;
                                    } else {
                                        ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                                        vertexArray3[0] = vertex;
                                        vertexArray3[1] = vertex2;
                                        vertexArray3[2] = vertex6;
                                        vertexArray = vertexArray3;
                                        vertexArray3[3] = vertex5;
                                    }
                                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvUp[2] : uvUp[0], mirrorV ? uvUp[3] : uvUp[1], mirrorU ? uvUp[0] : uvUp[2], mirrorV ? uvUp[1] : uvUp[3], textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().logModelCreationData) break block20;
                                    EMFUtils.log("uv-up failed for " + selfModelData.id);
                                }
                            }
                            try {
                                ModelPart.Vertex[] vertexArray;
                                if (mirrorV) {
                                    ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                                    vertexArray4[0] = vertex;
                                    vertexArray4[1] = vertex2;
                                    vertexArray4[2] = vertex6;
                                    vertexArray = vertexArray4;
                                    vertexArray4[3] = vertex5;
                                } else {
                                    ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                                    vertexArray5[0] = vertex8;
                                    vertexArray5[1] = vertex7;
                                    vertexArray5[2] = vertex3;
                                    vertexArray = vertexArray5;
                                    vertexArray5[3] = vertex4;
                                }
                                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvDown[2] : uvDown[0], mirrorV ? uvDown[3] : uvDown[1], mirrorU ? uvDown[0] : uvDown[2], mirrorV ? uvDown[1] : uvDown[3], textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().logModelCreationData) break block21;
                                EMFUtils.log("uv-down failed for " + selfModelData.id);
                            }
                        }
                        try {
                            ModelPart.Vertex[] vertexArray;
                            if (mirrorU) {
                                ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                                vertexArray6[0] = vertex;
                                vertexArray6[1] = vertex5;
                                vertexArray6[2] = vertex8;
                                vertexArray = vertexArray6;
                                vertexArray6[3] = vertex4;
                            } else {
                                ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                                vertexArray7[0] = vertex6;
                                vertexArray7[1] = vertex2;
                                vertexArray7[2] = vertex3;
                                vertexArray = vertexArray7;
                                vertexArray7[3] = vertex7;
                            }
                            sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvWest[2] : uvWest[0], mirrorV ? uvWest[3] : uvWest[1], mirrorU ? uvWest[0] : uvWest[2], mirrorV ? uvWest[1] : uvWest[3], textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().logModelCreationData) break block22;
                            EMFUtils.log("uv-west failed for " + selfModelData.id);
                        }
                    }
                    try {
                        sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? uvNorth[2] : uvNorth[0], mirrorV ? uvNorth[3] : uvNorth[1], mirrorU ? uvNorth[0] : uvNorth[2], mirrorV ? uvNorth[1] : uvNorth[3], textureWidth, textureHeight, false, Direction.NORTH));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().logModelCreationData) break block23;
                        EMFUtils.log("uv-north failed for " + selfModelData.id);
                    }
                }
                try {
                    ModelPart.Vertex[] vertexArray;
                    if (mirrorU) {
                        ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                        vertexArray8[0] = vertex6;
                        vertexArray8[1] = vertex2;
                        vertexArray8[2] = vertex3;
                        vertexArray = vertexArray8;
                        vertexArray8[3] = vertex7;
                    } else {
                        ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                        vertexArray9[0] = vertex;
                        vertexArray9[1] = vertex5;
                        vertexArray9[2] = vertex8;
                        vertexArray = vertexArray9;
                        vertexArray9[3] = vertex4;
                    }
                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvEast[2] : uvEast[0], mirrorV ? uvEast[3] : uvEast[1], mirrorU ? uvEast[0] : uvEast[2], mirrorV ? uvEast[1] : uvEast[3], textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().logModelCreationData) break block24;
                    EMFUtils.log("uv-east failed for " + selfModelData.id);
                }
            }
            try {
                sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? uvSouth[2] : uvSouth[0], mirrorV ? uvSouth[3] : uvSouth[1], mirrorU ? uvSouth[0] : uvSouth[2], mirrorV ? uvSouth[1] : uvSouth[3], textureWidth, textureHeight, false, Direction.SOUTH));
            }
            catch (Exception e) {
                if (!EMFConfig.getConfig().logModelCreationData) break block25;
                EMFUtils.log("uv-south failed for " + selfModelData.id);
            }
        }
        ((CuboidAccessor)cube).setSides(sides.toArray(new ModelPart.Polygon[0]));
        return cube;
    }
}

