/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import java.util.ArrayList;
import java.util.Objects;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.animation.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;

public class MathVariable
extends MathValue
implements MathComponent {
    final String variableName;
    public MathComponent optimizedAlternativeToThis = null;
    MathValue.ValueSupplier valueSupplier;
    private boolean invertBooleans = false;

    private MathVariable(String value, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        super(isNegative, calculationInstance);
        this.variableName = value;
        if (value.startsWith("!")) {
            value = value.replaceFirst("!", "");
            this.invertBooleans = true;
        }
        this.valueSupplier = switch (value) {
            case "limb_swing" -> EMFAnimationHelper::getLimbAngle;
            case "frame_time" -> EMFAnimationHelper::getFrameTime;
            case "limb_speed" -> EMFAnimationHelper::getLimbDistance;
            case "age" -> EMFAnimationHelper::getAge;
            case "head_pitch" -> EMFAnimationHelper::getHeadPitch;
            case "head_yaw" -> EMFAnimationHelper::getHeadYaw;
            case "swing_progress" -> EMFAnimationHelper::getSwingProgress;
            case "hurt_time" -> EMFAnimationHelper::getHurtTime;
            case "dimension" -> EMFAnimationHelper::getDimension;
            case "time" -> EMFAnimationHelper::getTime;
            case "player_pos_x" -> EMFAnimationHelper::getPlayerX;
            case "player_pos_y" -> EMFAnimationHelper::getPlayerY;
            case "player_pos_z" -> EMFAnimationHelper::getPlayerZ;
            case "pos_x" -> EMFAnimationHelper::getEntityX;
            case "pos_y" -> EMFAnimationHelper::getEntityY;
            case "pos_z" -> EMFAnimationHelper::getEntityZ;
            case "player_rot_x" -> EMFAnimationHelper::getPlayerRX;
            case "player_rot_y" -> EMFAnimationHelper::getPlayerRY;
            case "rot_x" -> EMFAnimationHelper::getEntityRX;
            case "rot_y" -> EMFAnimationHelper::getEntityRY;
            case "health" -> EMFAnimationHelper::getHealth;
            case "death_time" -> EMFAnimationHelper::getDeathTime;
            case "anger_time" -> EMFAnimationHelper::getAngerTime;
            case "max_health" -> EMFAnimationHelper::getMaxHealth;
            case "id" -> EMFAnimationHelper::getId;
            case "day_time" -> EMFAnimationHelper::getDayTime;
            case "day_count" -> EMFAnimationHelper::getDayCount;
            case "rule_index" -> EMFAnimationHelper::getRuleIndex;
            case "anger_time_start" -> EMFAnimationHelper::getAngerTimeStart;
            case "move_forward" -> EMFAnimationHelper::getMoveForward;
            case "move_strafing" -> EMFAnimationHelper::getMoveStrafe;
            case "nan" -> () -> EMFManager.getInstance().isAnimationValidationPhase ? 0.0f : Float.NaN;
            case "is_climbing" -> this.getBooleanAsFloat(EMFAnimationHelper::isClimbing);
            case "is_child" -> this.getBooleanAsFloat(EMFAnimationHelper::isChild);
            case "is_in_water" -> this.getBooleanAsFloat(EMFAnimationHelper::isInWater);
            case "is_riding" -> this.getBooleanAsFloat(EMFAnimationHelper::isRiding);
            case "is_on_ground" -> this.getBooleanAsFloat(EMFAnimationHelper::isOnGround);
            case "is_burning" -> this.getBooleanAsFloat(EMFAnimationHelper::isBurning);
            case "is_alive" -> this.getBooleanAsFloat(EMFAnimationHelper::isAlive);
            case "is_glowing" -> this.getBooleanAsFloat(EMFAnimationHelper::isGlowing);
            case "is_aggressive" -> this.getBooleanAsFloat(EMFAnimationHelper::isAggressive);
            case "is_hurt" -> this.getBooleanAsFloat(EMFAnimationHelper::isHurt);
            case "is_in_hand" -> this.getBooleanAsFloat(EMFAnimationHelper::isInHand);
            case "is_in_item_frame" -> this.getBooleanAsFloat(EMFAnimationHelper::isInItemFrame);
            case "is_in_ground" -> this.getBooleanAsFloat(EMFAnimationHelper::isInGround);
            case "is_in_gui" -> this.getBooleanAsFloat(EMFAnimationHelper::isInGui);
            case "is_in_lava" -> this.getBooleanAsFloat(EMFAnimationHelper::isInLava);
            case "is_invisible" -> this.getBooleanAsFloat(EMFAnimationHelper::isInvisible);
            case "is_on_head" -> this.getBooleanAsFloat(EMFAnimationHelper::isOnHead);
            case "is_on_shoulder" -> this.getBooleanAsFloat(EMFAnimationHelper::isOnShoulder);
            case "is_ridden" -> this.getBooleanAsFloat(EMFAnimationHelper::isRidden);
            case "is_sitting" -> this.getBooleanAsFloat(EMFAnimationHelper::isSitting);
            case "is_sneaking" -> this.getBooleanAsFloat(EMFAnimationHelper::isSneaking);
            case "is_sprinting" -> this.getBooleanAsFloat(EMFAnimationHelper::isSprinting);
            case "is_tamed" -> this.getBooleanAsFloat(EMFAnimationHelper::isTamed);
            case "is_wet" -> this.getBooleanAsFloat(EMFAnimationHelper::isWet);
            default -> this.getVariable(value);
        };
    }

    public static MathComponent getOptimizedVariable(String value, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        MathVariable method = new MathVariable(value, isNegative, calculationInstance);
        return Objects.requireNonNullElse(method.optimizedAlternativeToThis, method);
    }

    private MathValue.ValueSupplier getVariable(String variableKey) throws MathComponent.EMFMathException {
        switch (variableKey) {
            case "pi": {
                this.optimizedAlternativeToThis = this.isNegative ? MathConstant.PI_CONSTANT_NEGATIVE : MathConstant.PI_CONSTANT;
                return () -> (float)Math.PI;
            }
            case "true": {
                float bool = this.invertBooleans ? 0.0f : 1.0f;
                this.optimizedAlternativeToThis = this.invertBooleans ? MathConstant.ZERO : MathConstant.ONE;
                return () -> bool;
            }
            case "false": {
                float bool = this.invertBooleans ? 1.0f : 0.0f;
                this.optimizedAlternativeToThis = this.invertBooleans ? MathConstant.ONE : MathConstant.ZERO;
                return () -> bool;
            }
        }
        if (variableKey.matches("[a-zA-Z0-9_]+\\.([trs][xyz]$|visible$|visible_boxes$)")) {
            String[] split = variableKey.split("\\.");
            String partName = split[0];
            EMFModelOrRenderVariable partVariable = EMFModelOrRenderVariable.get(split[1]);
            EMFModelPart part = EMFManager.getModelFromHierarchichalId(partName, this.calculationInstance.allPartsBySingleAndFullHeirachicalId);
            if (partVariable != null && part != null) {
                return () -> partVariable.getValue(part);
            }
            EMFUtils.logError("no part found for: [" + variableKey + "] in [" + this.calculationInstance.modelName + "]. Available parts were: " + this.calculationInstance.allPartsBySingleAndFullHeirachicalId.keySet());
            this.optimizedAlternativeToThis = MathConstant.ZERO;
            return () -> 0.0f;
        }
        if (variableKey.matches("(var|varb)\\.\\w+")) {
            EMFAnimation variableCalculator = (EMFAnimation)this.calculationInstance.emfAnimationVariables.get((Object)variableKey);
            if (variableCalculator != null) {
                if (this.invertBooleans && variableKey.startsWith("varb.")) {
                    return () -> variableCalculator.getLastResultOnly() == 1.0f ? 0.0f : 1.0f;
                }
                return variableCalculator::getLastResultOnly;
            }
            ArrayList<String> vars = new ArrayList<String>();
            for (String var : this.calculationInstance.emfAnimationVariables.keySet()) {
                if (!var.startsWith("var.") && !var.startsWith("varb.")) continue;
                vars.add(var);
            }
            EMFUtils.logError("no animation variable found for: [" + variableKey + "] in [" + this.calculationInstance.modelName + "]. Available variables were: " + vars);
            this.optimizedAlternativeToThis = MathConstant.ZERO;
            return () -> 0.0f;
        }
        if (variableKey.matches("(render)\\.\\w+")) {
            EMFAnimation renderVariableCalculator = (EMFAnimation)this.calculationInstance.emfAnimationVariables.get((Object)variableKey);
            if (renderVariableCalculator != null) {
                return renderVariableCalculator::getLastResultOnly;
            }
            EMFModelOrRenderVariable variable = EMFModelOrRenderVariable.getRenderVariable(variableKey);
            if (variable != null && variable.isRenderVariable()) {
                return variable::getValue;
            }
            EMFUtils.logError("no render variable found for: [" + variableKey + "]");
            this.optimizedAlternativeToThis = MathConstant.ZERO;
            return () -> 0.0f;
        }
        String s = "ERROR: could not identify EMF animation variable [" + variableKey + "] for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier getBooleanAsFloat(BoolSupplierPrimitive boolGetter) {
        return () -> this.invertBooleans != boolGetter.get() ? 1.0f : 0.0f;
    }

    @Override
    public MathValue.ValueSupplier getSupplier() {
        return () -> this.valueSupplier.get();
    }

    public String toString() {
        return this.variableName + "=" + this.get();
    }

    private static interface BoolSupplierPrimitive {
        public boolean get();
    }
}

