/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfig {
    private static ETFConfig instance = null;
    public IllegalPathMode illegalPathSupportMode = IllegalPathMode.None;
    public boolean enableCustomTextures = true;
    public boolean enableCustomBlockEntities = true;
    public UpdateFrequency textureUpdateFrequency_V2 = UpdateFrequency.Fast;
    public boolean restrictBiome = true;
    public boolean restrictHeight = true;
    public boolean restrictBlock = true;
    public boolean restrictWeather = true;
    public boolean restrictDayTime = true;
    public boolean restrictMoonPhase = true;
    public boolean enableEmissiveTextures = true;
    public boolean enableEnchantedTextures = true;
    public boolean enableEmissiveBlockEntities = true;
    public ETFManager.EmissiveRenderModes emissiveRenderMode = ETFManager.EmissiveRenderModes.DULL;
    public boolean alwaysCheckVanillaEmissiveSuffix = true;
    public boolean skinFeaturesEnabled = true;
    public boolean skinFeaturesEnableTransparency = true;
    public boolean skinFeaturesEnableFullTransparency = false;
    public boolean tryETFTransparencyForAllSkins = false;
    public boolean enableEnemyTeamPlayersSkinFeatures = true;
    public boolean enableBlinking = true;
    public int blinkFrequency = 150;
    public int blinkLength = 1;
    public double advanced_IncreaseCacheSizeModifier = 1.0;
    public DebugLogMode debugLoggingMode = DebugLogMode.None;
    public boolean logTextureDataInitialization = false;
    public Set<String> ignoredConfigs2 = new HashSet<String>();
    public boolean hideConfigButton = false;
    public boolean disableVanillaDirectoryVariantTextures = false;
    public boolean use3DSkinLayerPatch = true;
    public boolean enableFullBodyWardenTextures = true;

    @NotNull
    public static ETFConfig getInstance() {
        if (instance == null) {
            instance = new ETFConfig();
        }
        return instance;
    }

    public static void setInstance(ETFConfig newConfigInstance) {
        instance = newConfigInstance;
    }

    public static void loadConfig() {
        try {
            File config = new File(ETFClientCommon.CONFIG_DIR, "entity_texture_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    instance = (ETFConfig)gson.fromJson((Reader)fileReader, ETFConfig.class);
                    fileReader.close();
                    ETFConfig.saveConfig();
                }
                catch (IOException e) {
                    ETFUtils2.logMessage("Config could not be loaded, using defaults", false);
                    instance = new ETFConfig();
                    ETFConfig.saveConfig();
                    ETFClientCommon.configHadLoadError = true;
                }
            } else {
                instance = new ETFConfig();
                ETFConfig.saveConfig();
            }
            if (instance == null) {
                ETFUtils2.logMessage("Config was null, using defaults", false);
                instance = new ETFConfig();
                ETFConfig.saveConfig();
                ETFClientCommon.configHadLoadError = true;
            }
        }
        catch (Exception e) {
            ETFUtils2.logError("Config was corrupt or broken, using defaults", false);
            instance = new ETFConfig();
            ETFConfig.saveConfig();
            ETFClientCommon.configHadLoadError = true;
        }
    }

    public static void saveConfig() {
        if (instance == null) {
            ETFUtils2.logError("Config file could not be saved: null", false);
        }
        File config = new File(ETFClientCommon.CONFIG_DIR, "entity_texture_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)instance));
            fileWriter.close();
        }
        catch (IOException e) {
            ETFUtils2.logError("Config file could not be saved: " + e.getMessage(), false);
        }
    }

    public static ETFConfig copyFrom(ETFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (ETFConfig)gson.fromJson(gson.toJson((Object)source), ETFConfig.class);
    }

    public static enum IllegalPathMode {
        None("options.off"),
        Entity("config.entity_texture_features.illegal_path_mode.entity"),
        All("config.entity_texture_features.illegal_path_mode.all");

        private final String key;

        private IllegalPathMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }

        public IllegalPathMode next() {
            switch (this) {
                case None: {
                    return Entity;
                }
                case Entity: {
                    return All;
                }
            }
            return None;
        }
    }

    public static enum UpdateFrequency {
        Never(-1),
        Slow(80),
        Average(20),
        Fast(5),
        Instant(1);

        private final int delay;

        private UpdateFrequency(int delay) {
            this.delay = delay;
        }

        public int getDelay() {
            return this.delay;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.getKey()).getString();
        }

        private String getKey() {
            switch (this.delay) {
                case -1: {
                    return "config.entity_texture_features.update_frequency.never";
                }
                case 80: {
                    return "config.entity_texture_features.update_frequency.slow";
                }
                case 20: {
                    return "config.entity_texture_features.update_frequency.average";
                }
                case 5: {
                    return "config.entity_texture_features.update_frequency.fast";
                }
                case 1: {
                    return "config.entity_texture_features.update_frequency.instant";
                }
            }
            return "config.entity_texture_features.error";
        }

        public UpdateFrequency next() {
            switch (this) {
                case Never: {
                    return Slow;
                }
                case Slow: {
                    return Average;
                }
                case Fast: {
                    return Instant;
                }
                case Instant: {
                    return Never;
                }
            }
            return Fast;
        }
    }

    public static enum DebugLogMode {
        None("config.entity_texture_features.Debug_log_mode.none"),
        Log("config.entity_texture_features.Debug_log_mode.log"),
        Chat("config.entity_texture_features.Debug_log_mode.chat");

        private final String key;

        private DebugLogMode(String key) {
            this.key = key;
        }

        public String toString() {
            return ETFVersionDifferenceHandler.getTextFromTranslation(this.key).getString();
        }

        public DebugLogMode next() {
            switch (this) {
                case None: {
                    return Log;
                }
                case Log: {
                    return Chat;
                }
            }
            return None;
        }
    }
}

