/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFRenderLayerWithTexture;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public class ETFRenderContext {
    public static boolean renderingFeatures = false;
    private static boolean allowRenderLayerTextureModify = true;
    private static ETFEntity currentEntity = null;
    private static int currentModelPartDepth = 0;
    private static boolean isInSpecialRenderOverlayPhase = false;
    private static boolean allowedToPatch = false;

    public static boolean isRenderingFeatures() {
        return renderingFeatures;
    }

    public static void setRenderingFeatures(boolean renderingFeatures) {
        ETFRenderContext.renderingFeatures = renderingFeatures;
    }

    public static boolean isAllowedToRenderLayerTextureModify() {
        return allowRenderLayerTextureModify;
    }

    public static void preventRenderLayerTextureModify() {
        allowRenderLayerTextureModify = false;
    }

    public static void allowRenderLayerTextureModify() {
        allowRenderLayerTextureModify = true;
    }

    public static ETFEntity getCurrentEntity() {
        return currentEntity;
    }

    public static void setCurrentEntity(ETFEntity currentEntity) {
        allowRenderLayerTextureModify = true;
        ETFRenderContext.currentEntity = currentEntity;
    }

    public static int getCurrentModelPartDepth() {
        return currentModelPartDepth;
    }

    public static void incrementCurrentModelPartDepth() {
        ++currentModelPartDepth;
    }

    public static void decrementCurrentModelPartDepth() {
        --currentModelPartDepth;
    }

    public static void resetCurrentModelPartDepth() {
        currentModelPartDepth = 0;
    }

    public static void reset() {
        currentModelPartDepth = 0;
        currentEntity = null;
        allowedToPatch = false;
        allowRenderLayerTextureModify = true;
    }

    public static boolean isIsInSpecialRenderOverlayPhase() {
        return isInSpecialRenderOverlayPhase;
    }

    public static void startSpecialRenderOverlayPhase() {
        isInSpecialRenderOverlayPhase = true;
    }

    public static void endSpecialRenderOverlayPhase() {
        isInSpecialRenderOverlayPhase = false;
    }

    public static boolean isAllowedToPatch() {
        return allowedToPatch;
    }

    public static void allowTexturePatching() {
        allowedToPatch = true;
    }

    public static void preventTexturePatching() {
        allowedToPatch = false;
    }

    public static RenderType modifyRenderLayerIfRequired(RenderType value) {
        ETFRenderLayerWithTexture multiphase;
        Optional<ResourceLocation> texture;
        if (ETFRenderContext.isCurrentlyRenderingEntity() && ETFRenderContext.isAllowedToRenderLayerTextureModify() && ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.containsKey(currentEntity.etf$getType()) && !value.m_5492_() && value instanceof ETFRenderLayerWithTexture && (texture = (multiphase = (ETFRenderLayerWithTexture)value).etf$getId()).isPresent()) {
            ETFRenderContext.preventRenderLayerTextureModify();
            RenderType forReturn = switch (ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.getInt(currentEntity.etf$getType())) {
                case 1 -> RenderType.m_110473_((ResourceLocation)texture.get());
                case 2 -> RenderType.m_110470_((ResourceLocation)texture.get());
                case 3 -> RenderType.m_173242_();
                case 4 -> RenderType.m_110491_((ResourceLocation)texture.get());
                default -> value;
            };
            ETFRenderContext.allowRenderLayerTextureModify();
            return forReturn;
        }
        return value;
    }

    public static void insertETFDataIntoVertexConsumer(MultiBufferSource provider, RenderType renderLayer, VertexConsumer vertexConsumer) {
        if (ETFRenderContext.isCurrentlyRenderingEntity() && vertexConsumer instanceof ETFVertexConsumer) {
            ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertexConsumer;
            etfVertexConsumer.etf$initETFVertexConsumer(provider, renderLayer);
        }
    }

    public static boolean isCurrentlyRenderingEntity() {
        return currentEntity != null;
    }
}

