/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityIntLRU;

public abstract class ETFTextureVariator {
    @NotNull
    public static ETFTextureVariator of(@NotNull ResourceLocation vanillaIdentifier) {
        ETFApi.ETFVariantSuffixProvider variantProvider;
        if (ETFConfig.getInstance().enableCustomTextures && (variantProvider = ETFApi.ETFVariantSuffixProvider.getVariantProviderOrNull(ETFUtils2.replaceIdentifier(vanillaIdentifier, ".png", ".properties"), vanillaIdentifier, "skins", "textures")) != null) {
            return new ETFTextureMultiple(vanillaIdentifier, variantProvider);
        }
        return new ETFTextureSingleton(vanillaIdentifier);
    }

    /*
     * Unable to fully structure code
     */
    public ETFTexture getVariantOf(@NotNull ETFEntity entity) {
        block2: {
            if (ETFManager.getInstance().ENTITY_DEBUG == null || !ETFManager.getInstance().ENTITY_DEBUG.equals(entity.etf$getUuid())) break block2;
            inChat = ETFConfig.getInstance().debugLoggingMode == ETFConfig.DebugLogMode.Chat;
            output = this.getVariantOfInternal(entity);
            v0 = ETFManager.getInstance().getGeneralPrintout();
            v1 = entity.etf$getType().m_20675_();
            var5_4 = this;
            if (!(var5_4 instanceof ETFTextureMultiple)) ** GOTO lbl-1000
            multi = (ETFTextureMultiple)var5_4;
            if (multi.suffixProvider.entityCanUpdate(entity.etf$getUuid())) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            ETFUtils2.logMessage("\n\u00a7e-----------ETF Debug Printout-------------\u00a7r\n" + v0 + "\n\u00a7eEntity:\u00a7r\n\u00a76 - type:\u00a7r " + v1 + "\n\u00a76 - texture:\u00a7r " + output + "\n\u00a76 - can_update_variant:\u00a7r " + v2 + "\n\u00a76 - last matching rule:\u00a7r " + ETFManager.getInstance().LAST_MET_RULE_INDEX.getInt(entity.etf$getUuid()) + "\n" + this.getPrintout() + "\n\u00a7e----------------------------------------\u00a7r", inChat);
            ETFManager.getInstance().ENTITY_DEBUG = null;
            return output;
        }
        return this.getVariantOfInternal(entity);
    }

    public abstract String getPrintout();

    @NotNull
    protected abstract ETFTexture getVariantOfInternal(@NotNull ETFEntity var1);

    private static class ETFTextureMultiple
    extends ETFTextureVariator {
        @NotNull
        public final EntityIntLRU entitySuffixMap = new EntityIntLRU(500);
        @NotNull
        private final Int2ObjectArrayMap<ETFTexture> variantMap = new Int2ObjectArrayMap();
        @NotNull
        final ETFApi.ETFVariantSuffixProvider suffixProvider;
        @NotNull
        private final ResourceLocation vanillaId;

        ETFTextureMultiple(@NotNull ResourceLocation vanillaId, @NotNull ETFApi.ETFVariantSuffixProvider suffixProvider) {
            this.vanillaId = vanillaId;
            this.entitySuffixMap.defaultReturnValue(-1);
            this.suffixProvider = suffixProvider;
            ResourceLocation directorized = ETFDirectory.getDirectoryVersionOf(vanillaId);
            ETFTexture vanilla = ETFManager.getInstance().getETFTextureNoVariation(directorized == null ? vanillaId : directorized);
            this.variantMap.put(1, (Object)vanilla);
            this.variantMap.defaultReturnValue((Object)vanilla);
            boolean logging = ETFConfig.getInstance().logTextureDataInitialization;
            if (logging) {
                ETFUtils2.logMessage("Initializing texture for the first time: " + vanillaId);
            }
            IntOpenHashSet suffixes = suffixProvider.getAllSuffixes();
            suffixes.remove(0);
            suffixes.remove(1);
            IntIterator intIterator = suffixes.iterator();
            while (intIterator.hasNext()) {
                int suffix = (Integer)intIterator.next();
                ResourceLocation variant = ETFDirectory.getDirectoryVersionOf(ETFUtils2.addVariantNumberSuffix(vanillaId, suffix));
                if (logging) {
                    ETFUtils2.logMessage(" - looked for variant: " + variant);
                }
                if (variant != null) {
                    this.variantMap.put(suffix, (Object)ETFManager.getInstance().getETFTextureNoVariation(variant));
                    continue;
                }
                if (logging) {
                    ETFUtils2.logMessage("   - failed to find variant: " + suffix);
                }
                this.variantMap.put(suffix, (Object)vanilla);
            }
            if (logging) {
                ETFUtils2.logMessage("Final variant map for: " + vanillaId);
                this.variantMap.forEach((k, v) -> ETFUtils2.logMessage(" - " + k + " = " + v));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ETFTextureMultiple that = (ETFTextureMultiple)o;
            return this.vanillaId.equals((Object)that.vanillaId);
        }

        public int hashCode() {
            return Objects.hash(this.vanillaId);
        }

        @Override
        public String getPrintout() {
            return "\u00a7bTexture: \u00a7r\n\u00a73 - base texture:\u00a7r " + this.vanillaId + "\n\u00a73 - variates:\u00a7r yes\n\u00a73 - set by properties:\u00a7r " + (this.suffixProvider instanceof PropertiesRandomProvider) + "\n\u00a73 - variant count:\u00a7r " + this.variantMap.size() + "\n\u00a73 - all suffixes:\u00a7r " + this.variantMap.keySet();
        }

        public void checkIfShouldExpireEntity(UUID id) {
            if (this.suffixProvider.entityCanUpdate(id)) {
                switch (ETFConfig.getInstance().textureUpdateFrequency_V2) {
                    case Never: {
                        break;
                    }
                    case Instant: {
                        this.entitySuffixMap.removeInt(id);
                        break;
                    }
                    default: {
                        int delay = ETFConfig.getInstance().textureUpdateFrequency_V2.getDelay();
                        int time = (int)(ETFRenderContext.getCurrentEntity().etf$getWorld().m_46467_() % (long)delay);
                        if (time != Math.abs(id.hashCode()) % delay) break;
                        this.entitySuffixMap.removeInt(id);
                    }
                }
            }
        }

        @Override
        @NotNull
        protected ETFTexture getVariantOfInternal(@NotNull ETFEntity entity) {
            int newSuffix;
            ETFManager.TextureSource source = ETFRenderContext.isRenderingFeatures() ? ETFManager.TextureSource.ENTITY_FEATURE : (entity.etf$isBlockEntity() ? ETFManager.TextureSource.BLOCK_ENTITY : ETFManager.TextureSource.ENTITY);
            UUID id = entity.etf$getUuid();
            int knownSuffix = this.entitySuffixMap.getInt(id);
            if (knownSuffix != -1) {
                if (source != ETFManager.TextureSource.BLOCK_ENTITY) {
                    this.checkIfShouldExpireEntity(id);
                }
                return (ETFTexture)this.variantMap.get(knownSuffix);
            }
            if (source == ETFManager.TextureSource.ENTITY_FEATURE) {
                int baseEntitySuffix;
                newSuffix = this.suffixProvider instanceof PropertiesRandomProvider ? this.suffixProvider.getSuffixForETFEntity(entity) : ((baseEntitySuffix = ETFManager.getInstance().LAST_SUFFIX_OF_ENTITY.getInt(ETFRenderContext.getCurrentEntity().etf$getUuid())) != -1 && this.variantMap.containsKey(baseEntitySuffix) ? baseEntitySuffix : this.suffixProvider.getSuffixForETFEntity(entity));
            } else {
                newSuffix = this.suffixProvider.getSuffixForETFEntity(entity);
                ETFManager.getInstance().LAST_SUFFIX_OF_ENTITY.put(id, newSuffix);
            }
            this.entitySuffixMap.put(id, newSuffix);
            return (ETFTexture)this.variantMap.get(newSuffix);
        }
    }

    public static class ETFTextureSingleton
    extends ETFTextureVariator {
        private final ETFTexture self;

        public ETFTextureSingleton(ResourceLocation singletonId) {
            this.self = ETFManager.getInstance().getETFTextureNoVariation(singletonId);
            if (ETFConfig.getInstance().logTextureDataInitialization) {
                ETFUtils2.logMessage("Initializing texture for the first time: " + singletonId);
                ETFUtils2.logMessage(" - no variants for: " + this.self);
            }
        }

        @Override
        @NotNull
        protected ETFTexture getVariantOfInternal(@NotNull ETFEntity entity) {
            return this.self;
        }

        @Override
        public String getPrintout() {
            return "\u00a7bTexture: \u00a7r\n\u00a73 - base texture:\u00a7r " + this.self.toString() + "\n\u00a73 - variates:\u00a7r no";
        }
    }
}

