/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.forge.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFVertexConsumer;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Unique
    private ETFTexture thisETF$Texture = null;
    @Unique
    private ETFTexture thisETF$TrimTexture = null;

    public MixinArmorFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    private void etf$markNotToChange(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        ETFRenderContext.preventRenderLayerTextureModify();
        ETFRenderContext.allowTexturePatching();
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="RETURN")})
    private void etf$markAllowedToChange(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        ETFRenderContext.allowRenderLayerTextureModify();
        ETFRenderContext.preventTexturePatching();
    }

    @ModifyArg(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderModel(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/item/ArmorItem;Lnet/minecraft/client/model/Model;ZFFFLnet/minecraft/util/Identifier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderLayer;getArmorCutoutNoCull(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeTexture(ResourceLocation texture) {
        this.thisETF$Texture = ETFManager.getInstance().getETFTextureNoVariation(texture);
        if (this.thisETF$Texture != null) {
            this.thisETF$Texture.reRegisterBaseTexture();
            return this.thisETF$Texture.getTextureIdentifier(null);
        }
        return texture;
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderModel(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/item/ArmorItem;Lnet/minecraft/client/model/Model;ZFFFLnet/minecraft/util/Identifier;)V"}, at={@At(value="TAIL")})
    private void etf$applyEmissive(PoseStack arg, MultiBufferSource arg2, int i, ArmorItem arg3, Model arg4, boolean bl, float f, float g, float h, ResourceLocation armorResource, CallbackInfo ci) {
        ResourceLocation emissive;
        if (this.thisETF$Texture != null && ETFConfig.getInstance().enableEmissiveTextures && (emissive = this.thisETF$Texture.getEmissiveIdentifierOfCurrentState()) != null) {
            VertexConsumer textureVert = arg2.m_6299_(RenderType.m_110431_((ResourceLocation)emissive));
            ETFRenderContext.startSpecialRenderOverlayPhase();
            arg4.m_7695_(arg, textureVert, 0xF000F2, OverlayTexture.f_118083_, f, g, h, 1.0f);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$cancelIfUi(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91080_ instanceof ETFConfigScreen) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderTrim(Lnet/minecraft/item/ArmorMaterial;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/item/trim/ArmorTrim;Lnet/minecraft/client/model/Model;Z)V"}, at={@At(value="HEAD")})
    private void etf$trimGet(ArmorMaterial material, PoseStack arg2, MultiBufferSource vertexConsumers, int i, ArmorTrim trim, Model arg5, boolean leggings, CallbackInfo ci) {
        ResourceLocation trimBaseId = leggings ? trim.m_267774_(material) : trim.m_267606_(material);
        ResourceLocation trimMaterialIdentifier = new ResourceLocation(trimBaseId.m_135827_(), "textures/" + trimBaseId.m_135815_() + ".png");
        this.thisETF$TrimTexture = ETFManager.getInstance().getETFTextureNoVariation(trimMaterialIdentifier);
        if (!this.thisETF$TrimTexture.exists() && ETFConfig.getInstance().enableEmissiveTextures && this.thisETF$TrimTexture.isEmissive() && ETFClientCommon.IRIS_DETECTED) {
            this.thisETF$TrimTexture.buildTrimTexture(trim, leggings);
        }
    }

    @ModifyArg(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderTrim(Lnet/minecraft/item/ArmorMaterial;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/item/trim/ArmorTrim;Lnet/minecraft/client/model/Model;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/Model;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V"), index=1)
    private VertexConsumer etf$changeTrim(VertexConsumer par2) {
        ETFVertexConsumer etfVertexConsumer;
        if (this.thisETF$TrimTexture != null && par2 instanceof ETFVertexConsumer && (etfVertexConsumer = (ETFVertexConsumer)par2).etf$getProvider() != null) {
            if (this.thisETF$TrimTexture.exists()) {
                return etfVertexConsumer.etf$getProvider().m_6299_(RenderType.m_110431_((ResourceLocation)this.thisETF$TrimTexture.getTextureIdentifier(null)));
            }
            if (ETFConfig.getInstance().enableEmissiveTextures && this.thisETF$TrimTexture.isEmissive() && ETFClientCommon.IRIS_DETECTED) {
                return etfVertexConsumer.etf$getProvider().m_6299_(RenderType.m_110431_((ResourceLocation)ETFManager.getErrorETFTexture().thisIdentifier));
            }
        }
        return par2;
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderTrim(Lnet/minecraft/item/ArmorMaterial;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/item/trim/ArmorTrim;Lnet/minecraft/client/model/Model;Z)V"}, at={@At(value="TAIL")})
    private void etf$trimEmissive(ArmorMaterial arg, PoseStack arg2, MultiBufferSource arg3, int i, ArmorTrim arg4, Model arg5, boolean bl, CallbackInfo ci) {
        ResourceLocation emissive;
        if (ETFConfig.getInstance().enableEmissiveTextures && this.thisETF$TrimTexture != null && (emissive = this.thisETF$TrimTexture.getEmissiveIdentifierOfCurrentState()) != null) {
            VertexConsumer textureVert = arg3.m_6299_(RenderType.m_110431_((ResourceLocation)emissive));
            ETFRenderContext.startSpecialRenderOverlayPhase();
            arg5.m_7695_(arg2, textureVert, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }
}

