/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

@Mixin(value={RenderType.class})
public abstract class MixinRenderLayer {
    @Unique
    private static ResourceLocation etf$getETFVariantOf(ResourceLocation identifier) {
        ResourceLocation modified;
        if (ETFRenderContext.getCurrentEntity() == null || !ETFRenderContext.isAllowedToRenderLayerTextureModify()) {
            return identifier;
        }
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(identifier, ETFRenderContext.getCurrentEntity());
        if (ETFRenderContext.isAllowedToPatch()) {
            etfTexture.assertPatchedTextures();
        }
        return (modified = etfTexture.getTextureIdentifier(ETFRenderContext.getCurrentEntity())) == null ? identifier : modified;
    }

    @ModifyVariable(method={"getEntitySolid", "getEyes", "getEnergySwirl", "getEntityAlpha", "getItemEntityTranslucentCull", "getEntityCutout", "getEntityCutoutNoCull(Lnet/minecraft/util/Identifier;Z)Lnet/minecraft/client/render/RenderLayer;", "getEntityCutoutNoCullZOffset(Lnet/minecraft/util/Identifier;Z)Lnet/minecraft/client/render/RenderLayer;", "getEntityDecal", "getEntityNoOutline", "getEntitySmoothCutout", "getEntityTranslucent(Lnet/minecraft/util/Identifier;Z)Lnet/minecraft/client/render/RenderLayer;", "getEntityTranslucentCull", "getEntityTranslucentEmissive(Lnet/minecraft/util/Identifier;Z)Lnet/minecraft/client/render/RenderLayer;", "getArmorCutoutNoCull"}, at=@At(value="HEAD"), index=0, argsOnly=true)
    private static ResourceLocation etf$mixinAllEntityLayers(ResourceLocation value) {
        return MixinRenderLayer.etf$getETFVariantOf(value);
    }
}

