/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

@Mixin(value={Material.class})
public class MixinSpriteIdentifier {
    @Inject(method={"getVertexConsumer(Lnet/minecraft/client/render/VertexConsumerProvider;Ljava/util/function/Function;)Lnet/minecraft/client/render/VertexConsumer;"}, at={@At(value="RETURN")}, cancellable=true)
    private void etf$modifyIfRequired(MultiBufferSource vertexConsumers, Function<ResourceLocation, RenderType> layerFactory, CallbackInfoReturnable<VertexConsumer> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof SpriteCoordinateExpander) {
            SpriteCoordinateExpander spriteTexturedVertexConsumer = (SpriteCoordinateExpander)object;
            ResourceLocation rawId = spriteTexturedVertexConsumer.f_110796_.m_245424_().m_246162_();
            ResourceLocation actualTexture = rawId.toString().endsWith(".png") ? rawId : new ResourceLocation(rawId.m_135827_(), "textures/" + rawId.m_135815_() + ".png");
            ETFTexture texture = ETFManager.getInstance().getETFTextureVariant(actualTexture, ETFRenderContext.getCurrentEntity());
            if (texture.getVariantNumber() != 0 || texture.isEmissive() || texture.isEnchanted()) {
                VertexConsumer consumer;
                ETFRenderContext.preventRenderLayerTextureModify();
                RenderType layer = layerFactory.apply(texture.thisIdentifier);
                ETFRenderContext.allowRenderLayerTextureModify();
                if (layer != null && (consumer = vertexConsumers.m_6299_(layer)) != null) {
                    cir.setReturnValue((Object)consumer);
                }
            }
        }
    }
}

