/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.compat.ETF3DSkinLayersUtil;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.player.ETFPlayerFeatureRenderer;
import traben.entity_texture_features.features.player.ETFPlayerSkinHolder;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerEntityRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements ETFPlayerSkinHolder {
    ETFPlayerTexture etf$ETFPlayerTexture = null;

    public MixinPlayerEntityRenderer(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void etf$addFeatures(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        PlayerRenderer self = (PlayerRenderer)this;
        this.m_115326_(new ETFPlayerFeatureRenderer(self));
    }

    @Inject(method={"renderArm"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/PlayerEntityModel;setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void etf$redirectNicely(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        ResourceLocation etfTexture;
        ETFPlayerTexture thisETFPlayerTexture;
        arm.f_104203_ = 0.0f;
        sleeve.f_104203_ = 0.0f;
        if (ETFConfig.getInstance().skinFeaturesEnabled && (thisETFPlayerTexture = ETFManager.getInstance().getPlayerTexture((Player)player, player.m_108560_())) != null && thisETFPlayerTexture.hasFeatures && (etfTexture = thisETFPlayerTexture.getBaseTextureIdentifierOrNullForVanilla((Player)player)) != null) {
            ETFRenderContext.preventRenderLayerTextureModify();
            arm.f_104203_ = 0.0f;
            sleeve.f_104203_ = 0.0f;
            VertexConsumer vc1 = vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)etfTexture));
            this.etf$renderOnce(matrices, vc1, light, player, arm, sleeve);
            ETFRenderContext.startSpecialRenderOverlayPhase();
            ResourceLocation emissive = thisETFPlayerTexture.getBaseTextureEmissiveIdentifierOrNullForNone();
            if (emissive != null) {
                VertexConsumer vc2 = vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)emissive));
                this.etf$renderOnce(matrices, vc2, 0xF000F2, player, arm, sleeve);
            }
            if (thisETFPlayerTexture.baseEnchantIdentifier != null) {
                VertexConsumer vc3 = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumers, (RenderType)RenderType.m_110431_((ResourceLocation)thisETFPlayerTexture.baseEnchantIdentifier), (boolean)false, (boolean)true);
                this.etf$renderOnce(matrices, vc3, light, player, arm, sleeve);
            }
            ETFRenderContext.endSpecialRenderOverlayPhase();
            ETFRenderContext.allowRenderLayerTextureModify();
            ci.cancel();
        }
    }

    @Unique
    private void etf$renderOnce(PoseStack matrixStack, VertexConsumer consumer, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve) {
        arm.m_104301_(matrixStack, consumer, light, OverlayTexture.f_118083_);
        sleeve.m_104301_(matrixStack, consumer, light, OverlayTexture.f_118083_);
        if (ETFClientCommon.SKIN_LAYERS_DETECTED && ETFConfig.getInstance().use3DSkinLayerPatch) {
            try {
                ETF3DSkinLayersUtil.renderHand((PlayerRenderer)this, matrixStack, consumer, light, player, arm, sleeve);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError error) {
                ETFUtils2.logError("Error with ETF's 3D skin layers mod hand compatibility: " + error);
                error.printStackTrace();
                ETFClientCommon.SKIN_LAYERS_DETECTED = false;
            }
        }
    }

    @Inject(method={"getTexture(Lnet/minecraft/client/network/AbstractClientPlayerEntity;)Lnet/minecraft/util/Identifier;"}, at={@At(value="RETURN")}, cancellable=true)
    private void etf$getTexture(AbstractClientPlayer abstractClientPlayerEntity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (ETFConfig.getInstance().skinFeaturesEnabled) {
            ResourceLocation texture;
            this.etf$ETFPlayerTexture = ETFManager.getInstance().getPlayerTexture((Player)abstractClientPlayerEntity, (ResourceLocation)cir.getReturnValue());
            if (this.etf$ETFPlayerTexture != null && this.etf$ETFPlayerTexture.hasFeatures && (texture = this.etf$ETFPlayerTexture.getBaseTextureIdentifierOrNullForVanilla((Player)abstractClientPlayerEntity)) != null) {
                cir.setReturnValue((Object)texture);
            }
        } else {
            this.etf$ETFPlayerTexture = null;
        }
    }

    @Override
    @Nullable
    public ETFPlayerTexture etf$getETFPlayerTexture() {
        return this.etf$ETFPlayerTexture;
    }
}

