/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarning;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarnings;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

public abstract class ETFUtils2 {
    public static boolean renderEmissive(ETFTexture texture, MultiBufferSource provider, RenderMethodForOverlay renderer) {
        ResourceLocation emissive = texture.getEmissiveIdentifierOfCurrentState();
        if (emissive != null) {
            boolean textureIsAllowedBrightRender;
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            boolean bl = textureIsAllowedBrightRender = ETFManager.getEmissiveMode() == ETFManager.EmissiveRenderModes.BRIGHT && ETFRenderContext.getCurrentEntity().etf$canBeBright();
            VertexConsumer emissiveConsumer = provider.m_6299_(textureIsAllowedBrightRender ? RenderType.m_110460_((ResourceLocation)emissive, (boolean)true) : (ETFRenderContext.getCurrentEntity().etf$isBlockEntity() ? RenderType.m_110470_((ResourceLocation)emissive) : RenderType.m_110473_((ResourceLocation)emissive)));
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            renderer.render(emissiveConsumer, 0xF000F2);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    public static boolean renderEnchanted(ETFTexture texture, MultiBufferSource provider, int light, RenderMethodForOverlay renderer) {
        ResourceLocation enchanted = texture.getEnchantIdentifierOfCurrentState();
        if (enchanted != null) {
            boolean wasAllowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
            ETFRenderContext.preventRenderLayerTextureModify();
            VertexConsumer enchantedVertex = ItemRenderer.m_115184_((MultiBufferSource)provider, (RenderType)RenderType.m_110431_((ResourceLocation)enchanted), (boolean)false, (boolean)true);
            if (wasAllowed) {
                ETFRenderContext.allowRenderLayerTextureModify();
            }
            ETFRenderContext.startSpecialRenderOverlayPhase();
            renderer.render(enchantedVertex, light);
            ETFRenderContext.endSpecialRenderOverlayPhase();
            return true;
        }
        return false;
    }

    @NotNull
    public static ResourceLocation addVariantNumberSuffix(ResourceLocation identifier, int variant) {
        return new ResourceLocation(ETFUtils2.addVariantNumberSuffix(identifier.toString(), variant));
    }

    @NotNull
    public static String addVariantNumberSuffix(String identifierString, int variant) {
        String file;
        if (identifierString.endsWith(".png")) {
            file = "png";
        } else {
            String[] split = identifierString.split("\\.");
            file = split[split.length - 1];
        }
        if (variant < 2) {
            return identifierString;
        }
        if (identifierString.matches("\\D+\\d+\\." + file)) {
            return identifierString.replace("." + file, "." + variant + "." + file);
        }
        return identifierString.replace("." + file, variant + "." + file);
    }

    @Nullable
    public static ResourceLocation replaceIdentifier(ResourceLocation id, String regex, String replace) {
        ResourceLocation forReturn;
        if (id == null) {
            return null;
        }
        try {
            forReturn = new ResourceLocation(id.m_135827_(), id.m_135815_().replaceFirst(regex, replace));
        }
        catch (ResourceLocationException idFail) {
            ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.illegal_path_recommendation").getString() + "\n" + idFail);
            forReturn = null;
        }
        catch (Exception e) {
            forReturn = null;
        }
        return forReturn;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseMultiple(String[] packNameList) {
        ArrayList<String> packNames = new ArrayList<String>(Arrays.asList(packNameList));
        while (packNames.size() >= 2) {
            if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(0)) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(1))) {
                packNames.remove(1);
                continue;
            }
            packNames.remove(0);
        }
        return packNames.get(0);
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseTwo(String pack1, String pack2) {
        if (pack1 == null) {
            return null;
        }
        if (pack1.equals(pack2)) {
            return pack1;
        }
        if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(pack1) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(pack2)) {
            return pack1;
        }
        return pack2;
    }

    @Nullable
    public static Properties readAndReturnPropertiesElseNull(ResourceLocation path) {
        Properties props = new Properties();
        try {
            Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(path).get();
            try {
                InputStream in = resource.m_215507_();
                props.load(in);
                in.close();
                return props;
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NativeImage getNativeImageElseNull(@Nullable ResourceLocation identifier) {
        NativeImage image;
        if (identifier != null && (image = ETFManager.getInstance().KNOWN_NATIVE_IMAGES.get(identifier)) != null) {
            return image;
        }
        try {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(identifier);
            if (resource.isPresent()) {
                InputStream in = ((Resource)resource.get()).m_215507_();
                try {
                    NativeImage img = NativeImage.m_85058_((InputStream)in);
                    in.close();
                    ETFManager.getInstance().KNOWN_NATIVE_IMAGES.put(identifier, img);
                    return img;
                }
                catch (Exception e) {
                    in.close();
                    return null;
                }
            }
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(identifier);
            if (texture instanceof DynamicTexture) {
                DynamicTexture nativeImageBackedTexture = (DynamicTexture)texture;
                return nativeImageBackedTexture.m_117991_();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logMessage(String obj) {
        ETFUtils2.logMessage(obj, false);
    }

    public static void logMessage(String obj, boolean inChat) {
        if (!((String)obj).endsWith(".")) {
            obj = (String)obj + ".";
        }
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("\u00a7a[INFO]\u00a7r [Entity Texture Features]: " + (String)obj)), false);
            } else {
                ETFClientCommon.LOGGER.info((String)obj);
            }
        } else {
            ETFClientCommon.LOGGER.info((String)obj);
        }
    }

    public static void logWarn(String obj) {
        ETFUtils2.logWarn(obj, false);
    }

    public static void logWarn(String obj, boolean inChat) {
        if (!((String)obj).endsWith(".")) {
            obj = (String)obj + ".";
        }
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("\u00a7e[WARN]\u00a7r [Entity Texture Features]: " + (String)obj)).m_130940_(ChatFormatting.YELLOW), false);
            } else {
                ETFClientCommon.LOGGER.warn((String)obj);
            }
        } else {
            ETFClientCommon.LOGGER.warn((String)obj);
        }
    }

    public static void logError(String obj) {
        ETFUtils2.logError(obj, false);
    }

    public static void logError(String obj, boolean inChat) {
        if (!((String)obj).endsWith(".")) {
            obj = (String)obj + ".";
        }
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("\u00a74[ERROR]\u00a7r [Entity Texture Features]: " + (String)obj)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
            } else {
                ETFClientCommon.LOGGER.error((String)obj);
            }
        } else {
            ETFClientCommon.LOGGER.error((String)obj);
        }
    }

    public static NativeImage emptyNativeImage() {
        return ETFUtils2.emptyNativeImage(64, 64);
    }

    public static NativeImage emptyNativeImage(int Width, int Height) {
        NativeImage empty = new NativeImage(Width, Height, false);
        empty.m_84997_(0, 0, Width, Height, 0);
        return empty;
    }

    public static boolean registerNativeImageToIdentifier(NativeImage img, ResourceLocation identifier) {
        if (img != null && identifier != null) {
            DynamicTexture bob = new DynamicTexture(img);
            Minecraft.m_91087_().m_91097_().m_118495_(identifier, (AbstractTexture)bob);
            return true;
        }
        ETFUtils2.logError("registering native image failed: " + img + ", " + identifier);
        return false;
    }

    public static void checkModCompatibility() {
        for (ETFConfigWarning warning : ETFConfigWarnings.getRegisteredWarnings()) {
            warning.testWarningAndApplyFixIfEnabled();
        }
    }

    public static interface RenderMethodForOverlay {
        public void render(VertexConsumer var1, int var2);
    }
}

