/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon;

import com.mojang.logging.LogUtils;
import java.awt.Toolkit;
import java.util.function.BiConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import ru.auriny.epsilon.net.NetworkHandler;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@Mod(value="epsilon")
public class Epsilon {
    public static final String MODID = "epsilon";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Epsilon() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConstruct);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkHandler::register);
        LOGGER.info("[Epsilon] Network channel registered.");
    }

    private void onConstruct(FMLConstructModEvent e) {
        try {
            if (Platform.get() != Platform.MACOSX) {
                System.setProperty("java.awt.headless", "false");
                Toolkit.getDefaultToolkit();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventBusSubscriber(modid="epsilon", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    @GradleSideOnly(value={GradleSide.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            LOGGER.info("[Epsilon] headless={} graphicsenv={} java.home={}", new Object[]{System.getProperty("java.awt.headless"), System.getProperty("java.awt.graphicsenv"), System.getProperty("java.home")});
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (String.valueOf(k).toLowerCase().contains("awt") || String.valueOf(k).toLowerCase().contains("graphics")) {
                    LOGGER.info("[Epsilon] prop {}={}", k, v);
                }
            }));
        }
    }
}

