/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.auriny.epsilon.Epsilon;
import ru.auriny.epsilon.net.NetworkHandler;
import ru.auriny.epsilon.net.packet.RequestScreenshotPacket;
import ru.auriny.epsilon.net.packet.ScreenshotChunkPacket;
import ru.auriny.epsilon.net.packet.ScreenshotMetaPacket;

@OnlyIn(value=Dist.CLIENT)
public class ClientScreenshotHandler {
    private static final int CHUNK_SIZE = 30000;
    private static final int GAME_MAX_TOTAL_SIZE = 0x800000;
    private static final int SCREEN_MAX_SINGLE_SIZE = 0x1000000;
    private static final int SCREEN_MAX_COMPOSITE_SIZE = 0x2000000;
    private static final DateTimeFormatter TS = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private static final ExecutorService GAME_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "Epsilon-Game-Capture");
        t.setDaemon(true);
        return t;
    });
    private static final ExecutorService SCREEN_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "Epsilon-System-Capture");
        t.setDaemon(true);
        return t;
    });

    public static void onRequest(RequestScreenshotPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            if (!RenderSystem.isOnRenderThread()) {
                mc.execute(() -> ClientScreenshotHandler.captureGame(mc, pkt));
            } else {
                ClientScreenshotHandler.captureGame(mc, pkt);
            }
        });
        CompletableFuture.runAsync(() -> ClientScreenshotHandler.captureScreens(mc, pkt), SCREEN_EXECUTOR);
    }

    private static void captureGame(Minecraft mc, RequestScreenshotPacket pkt) {
        NativeImage img = ClientScreenshotHandler.gameFrame();
        if (img == null) {
            return;
        }
        CompletableFuture.supplyAsync(() -> ClientScreenshotHandler.encodeNativePng(img), GAME_EXECUTOR).thenAccept(bytes -> mc.execute(() -> {
            if (bytes == null) {
                return;
            }
            if (((byte[])bytes).length > 0x800000) {
                return;
            }
            ClientScreenshotHandler.sendBinary(mc, pkt, bytes, "game", "png");
        }));
    }

    private static void captureScreens(Minecraft mc, RequestScreenshotPacket pkt) {
        try {
            if (GraphicsEnvironment.isHeadless()) {
                Epsilon.LOGGER.warn("[Epsilon] Headless system");
                return;
            }
            GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            if (devs == null || devs.length == 0) {
                Epsilon.LOGGER.warn("[Epsilon] No devices");
                return;
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            Rectangle[] bounds = new Rectangle[devs.length];
            for (int i = 0; i < devs.length; ++i) {
                Rectangle b;
                bounds[i] = b = devs[i].getDefaultConfiguration().getBounds();
                if (b.x < minX) {
                    minX = b.x;
                }
                if (b.y < minY) {
                    minY = b.y;
                }
                if (b.x + b.width > maxX) {
                    maxX = b.x + b.width;
                }
                if (b.y + b.height <= maxY) continue;
                maxY = b.y + b.height;
            }
            int totalW = maxX - minX;
            int totalH = maxY - minY;
            int success = 0;
            BufferedImage composite = new BufferedImage(totalW, totalH, 2);
            Graphics2D gComp = composite.createGraphics();
            gComp.setColor(Color.BLACK);
            gComp.fillRect(0, 0, totalW, totalH);
            for (int i = 0; i < devs.length; ++i) {
                try {
                    int len;
                    Robot robot = new Robot(devs[i]);
                    Rectangle b = bounds[i];
                    BufferedImage one = robot.createScreenCapture(b);
                    ++success;
                    gComp.drawImage((Image)one, b.x - minX, b.y - minY, null);
                    byte[] singlePng = ClientScreenshotHandler.encodeBufferedPng(one);
                    if (singlePng == null || (len = singlePng.length) > 0x1000000) continue;
                    int idx = i;
                    mc.execute(() -> ClientScreenshotHandler.sendBinary(mc, pkt, singlePng, "screen" + idx, "png"));
                    continue;
                }
                catch (Exception ex) {
                    Epsilon.LOGGER.warn("[Epsilon] Monitor {} capture err {}", (Object)i, (Object)ex.toString());
                }
            }
            gComp.dispose();
            if (success == 0) {
                Epsilon.LOGGER.warn("[Epsilon] No monitors captured");
                return;
            }
            byte[] comp = ClientScreenshotHandler.encodeBufferedPng(composite);
            if (comp != null) {
                if (comp.length <= 0x2000000) {
                    mc.execute(() -> ClientScreenshotHandler.sendBinary(mc, pkt, comp, "screen_all", "png"));
                } else {
                    Epsilon.LOGGER.warn("[Epsilon] Composite too large {} > {}", (Object)comp.length, (Object)0x2000000);
                }
            } else {
                Epsilon.LOGGER.warn("[Epsilon] Composite encode null");
            }
        }
        catch (Throwable t) {
            Epsilon.LOGGER.warn("[Epsilon] System capture throwable {}", (Object)t.toString());
        }
    }

    private static void sendBinary(Minecraft mc, RequestScreenshotPacket pkt, byte[] data, String suffix, String ext) {
        if (data == null) {
            return;
        }
        String shooter = ClientScreenshotHandler.sanitize(mc.m_91094_().m_92546_());
        String requester = ClientScreenshotHandler.sanitize(pkt.requesterName());
        String ts = TS.format(ZonedDateTime.now(ZoneOffset.UTC));
        String filename = shooter + "_" + requester + "_" + ts + "_" + suffix + "." + ext;
        UUID id = UUID.randomUUID();
        Epsilon.LOGGER.info("[Epsilon] Send file={} size={}", (Object)filename, (Object)data.length);
        int total = (data.length + 30000 - 1) / 30000;
        NetworkHandler.CHANNEL.sendToServer((Object)new ScreenshotMetaPacket(id, filename, total));
        for (int i = 0; i < total; ++i) {
            int off = i * 30000;
            int len = Math.min(30000, data.length - off);
            byte[] part = Arrays.copyOfRange(data, off, off + len);
            if (part.length > 32750) {
                return;
            }
            NetworkHandler.CHANNEL.sendToServer((Object)new ScreenshotChunkPacket(id, i, part));
        }
    }

    private static NativeImage gameFrame() {
        try {
            RenderTarget rt = Minecraft.m_91087_().m_91385_();
            RenderSystem.assertOnRenderThread();
            NativeImage img = new NativeImage(rt.f_83915_, rt.f_83916_, false);
            rt.m_83956_();
            img.m_85045_(0, false);
            img.m_85122_();
            return img;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static byte[] encodeNativePng(NativeImage img) {
        byte[] byArray;
        block8: {
            NativeImage nativeImage = img;
            try {
                byArray = img.m_85121_();
                if (nativeImage == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            nativeImage.close();
        }
        return byArray;
    }

    private static byte[] encodeBufferedPng(BufferedImage img) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    private static String sanitize(String s) {
        if (s == null) {
            return "unknown";
        }
        return s.replaceAll("[^0-9A-Za-z_\\-]", "_");
    }
}

