/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon.net.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.epsilon.Epsilon;
import ru.auriny.epsilon.client.ClientScreenshotHandler;

public record RequestScreenshotPacket(String requesterName, String reason) {
    public static void encode(RequestScreenshotPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.requesterName == null ? "" : pkt.requesterName);
        buf.m_130070_(pkt.reason == null ? "" : pkt.reason);
    }

    public static RequestScreenshotPacket decode(FriendlyByteBuf buf) {
        String requester = buf.m_130136_(Short.MAX_VALUE);
        String reason = buf.m_130136_(Short.MAX_VALUE);
        return new RequestScreenshotPacket(requester, reason);
    }

    public static void handle(RequestScreenshotPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> {
            if (c.getDirection().getReceptionSide().isClient()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc == null) {
                    Epsilon.LOGGER.error("[Epsilon] Minecraft instance null in RequestScreenshotPacket.handle");
                    return;
                }
                Epsilon.LOGGER.info("[Epsilon] Received RequestScreenshotPacket requester='{}' reason='{}'", (Object)pkt.requesterName(), (Object)pkt.reason());
                ClientScreenshotHandler.onRequest(pkt);
            }
        });
        c.setPacketHandled(true);
    }
}

