/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon.net.packet;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.epsilon.Epsilon;
import ru.auriny.epsilon.server.storage.ScreenshotStorage;

public record ScreenshotChunkPacket(UUID id, int index, byte[] data) {
    public static void encode(ScreenshotChunkPacket p, FriendlyByteBuf buf) {
        buf.m_130077_(p.id);
        buf.writeInt(p.index);
        buf.writeInt(p.data.length);
        buf.writeBytes(p.data);
    }

    public static ScreenshotChunkPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        int index = buf.readInt();
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new ScreenshotChunkPacket(id, index, b);
    }

    public static void handle(ScreenshotChunkPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> {
            if (c.getDirection().getReceptionSide().isServer()) {
                if (c.getSender() == null) {
                    return;
                }
                Epsilon.LOGGER.debug("[Epsilon] Server got chunk id={} index={} size={}", new Object[]{pkt.id(), pkt.index(), pkt.data().length});
                ScreenshotStorage.handleChunk(pkt.id(), pkt.index(), pkt.data());
            }
        });
        c.setPacketHandled(true);
    }
}

