/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon.net.packet;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.epsilon.Epsilon;
import ru.auriny.epsilon.server.storage.ScreenshotStorage;

public record ScreenshotMetaPacket(UUID id, String filename, int totalChunks) {
    public static void encode(ScreenshotMetaPacket p, FriendlyByteBuf buf) {
        buf.m_130077_(p.id);
        buf.m_130070_(p.filename);
        buf.writeInt(p.totalChunks);
    }

    public static ScreenshotMetaPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        String name = buf.m_130136_(Short.MAX_VALUE);
        int total = buf.readInt();
        return new ScreenshotMetaPacket(id, name, total);
    }

    public static void handle(ScreenshotMetaPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> {
            if (c.getDirection().getReceptionSide().isServer()) {
                if (c.getSender() == null) {
                    return;
                }
                Epsilon.LOGGER.info("[Epsilon] Server received meta id={} file={} totalChunks={}", new Object[]{pkt.id(), pkt.filename(), pkt.totalChunks()});
                ScreenshotStorage.prepareIncoming(pkt.id(), pkt.filename(), pkt.totalChunks());
            }
        });
        c.setPacketHandled(true);
    }
}

