/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.epsilon.server.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.fml.loading.FMLPaths;
import ru.auriny.epsilon.Epsilon;

public class ScreenshotStorage {
    private static final File PATH = FMLPaths.CONFIGDIR.get().resolve("epsilon").resolve("screens").toFile();
    private static final long CLEANUP_TIMEOUT_MS = 300000L;
    private static final Map<UUID, Incoming> incoming = new ConcurrentHashMap<UUID, Incoming>();

    public static void prepareIncoming(UUID id, String filename, int totalChunks) {
        Epsilon.LOGGER.info("[Epsilon] prepareIncoming id={} file={} totalChunks={}", new Object[]{id, filename, totalChunks});
        if (totalChunks <= 0 || totalChunks > 4096) {
            Epsilon.LOGGER.warn("[Epsilon] Abnormal totalChunks {} for {}", (Object)totalChunks, (Object)filename);
            return;
        }
        if (!PATH.exists() && !PATH.mkdirs()) {
            Epsilon.LOGGER.error("[Epsilon] Cannot create screenshot directory: {}", (Object)PATH.getAbsolutePath());
            return;
        }
        incoming.put(id, new Incoming(filename, totalChunks));
    }

    public static void handleChunk(UUID id, int index, byte[] data) {
        Incoming inc = incoming.get(id);
        if (inc == null) {
            Epsilon.LOGGER.warn("[Epsilon] handleChunk: no incoming for id={} index={}", (Object)id, (Object)index);
            return;
        }
        if (index < 0 || index >= inc.total) {
            Epsilon.LOGGER.warn("[Epsilon] handleChunk: invalid index {} for id={}", (Object)index, (Object)id);
            return;
        }
        inc.parts.put(index, data);
        int rcv = inc.received.incrementAndGet();
        inc.lastUpdated = System.currentTimeMillis();
        Epsilon.LOGGER.debug("[Epsilon] Stored chunk {}/{} id={}", new Object[]{rcv, inc.total, id});
        if (rcv >= inc.total) {
            ScreenshotStorage.writeAndRemove(id, inc);
        }
        ScreenshotStorage.cleanupStale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndRemove(UUID id, Incoming inc) {
        File out = new File(PATH, inc.filename);
        Epsilon.LOGGER.info("[Epsilon] Writing screenshot id={} file={}", (Object)id, (Object)out.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(out);){
            for (int i = 0; i < inc.total; ++i) {
                byte[] part = inc.parts.get(i);
                if (part == null) {
                    Epsilon.LOGGER.warn("[Epsilon] Missing part {} for {}", (Object)i, (Object)inc.filename);
                    return;
                }
                fos.write(part);
            }
            Epsilon.LOGGER.info("[Epsilon] Saved screenshot {}", (Object)out.getAbsolutePath());
        }
        catch (IOException e) {
            Epsilon.LOGGER.error("[Epsilon] Error writing screenshot {}", (Object)inc.filename, (Object)e);
        }
        finally {
            incoming.remove(id);
        }
    }

    private static void cleanupStale() {
        long now = System.currentTimeMillis();
        incoming.entrySet().removeIf(e -> {
            boolean stale;
            boolean bl = stale = now - ((Incoming)e.getValue()).lastUpdated > 300000L;
            if (stale) {
                Epsilon.LOGGER.warn("[Epsilon] Cleaning stale screenshot id={} file={}", e.getKey(), (Object)((Incoming)e.getValue()).filename);
            }
            return stale;
        });
    }

    private static class Incoming {
        final String filename;
        final int total;
        final Map<Integer, byte[]> parts = new ConcurrentHashMap<Integer, byte[]>();
        final AtomicInteger received = new AtomicInteger(0);
        long lastUpdated = System.currentTimeMillis();

        Incoming(String filename, int total) {
            this.filename = filename;
            this.total = total;
        }
    }
}

