/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.utils.Color4F;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigWidget
extends ButtonWidget {
    protected ResourceLocation resourceLocation;
    protected float texOffX;
    protected float texOffY;
    protected float scale;
    protected Color4F color;
    protected boolean isShow;
    protected boolean isDisableable;
    protected boolean snapable;
    protected ResourceLocation icon;
    private final List<ConfigWidgetPosListener> posListeners = new ArrayList<ConfigWidgetPosListener>();
    private double d_x;
    private double d_y;

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, boolean snapable, String msg, boolean isShow, boolean isDisableable) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, isDisableable);
        this.snapable = snapable;
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, true);
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow, boolean isDisableable) {
        super(xIn, yIn, (int)((float)widthIn * scaleIn), (int)((float)heightIn * scaleIn), msg);
        this.d_x = xIn;
        this.d_y = yIn;
        this.isShow = isShow;
        this.scale = scaleIn;
        this.isDisableable = isDisableable;
        this.snapable = true;
    }

    public void addPosListener(ConfigWidgetPosListener act) {
        this.posListeners.add(act);
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn) {
        this.initTextureValues(xTexStartIn, yTexStartIn, color, resourceLocationIn, null);
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, Color4F color, ResourceLocation resourceLocationIn, ResourceLocation icon) {
        this.resourceLocation = resourceLocationIn;
        this.texOffX = (float)xTexStartIn * this.scale;
        this.texOffY = (float)yTexStartIn * this.scale;
        this.color = color;
        this.icon = icon;
    }

    private void renderBg(GuiGraphics gui) {
        gui.m_280411_(this.resourceLocation, this.x, this.y, 3, 3, 0.0f, 0.0f, 3, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + this.width - 3, this.y, 3, 3, 13.0f, 0.0f, 3, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x, this.y + this.height - 3, 3, 3, 0.0f, 13.0f, 3, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + this.width - 3, this.y + this.height - 3, 3, 3, 13.0f, 13.0f, 3, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + 3, this.y, this.width - 6, 3, 3.0f, 0.0f, 10, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + this.width - 3, this.y + 3, 3, this.height - 6, 13.0f, 3.0f, 3, 10, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + 3, this.y + this.height - 3, this.width - 6, 3, 3.0f, 13.0f, 10, 3, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x, this.y + 3, 3, this.height - 6, 0.0f, 3.0f, 3, 10, 256, 256);
        gui.m_280411_(this.resourceLocation, this.x + 3, this.y + 3, this.width - 6, this.height - 6, 3.0f, 3.0f, 10, 10, 256, 256);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mx, int my, float pTick) {
        super.render(gui, mx, my, pTick);
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)this.color.a);
        this.renderBg(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.icon != null) {
            int size = 16;
            if (this.width < 16) {
                size = this.width - 2;
            }
            gui.m_280163_(this.icon, this.x + this.width / 2 - size / 2, this.y + this.height / 2 - size / 2, (float)size, (float)size, size, size, size, size);
        }
        if (this.isDisableable) {
            if (this.isShow) {
                gui.m_280218_(this.resourceLocation, this.x + this.width - 12, this.y + 2, 162, 0, 10, 10);
            } else {
                gui.m_280218_(this.resourceLocation, this.x + this.width - 12, this.y + 2, 172, 0, 10, 10);
            }
        }
        RenderSystem.disableBlend();
        gui.m_280137_(minecraft.f_91062_, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 3, 0xFFFFFF);
    }

    public void onRelease(double p_onRelease_1_, double p_onRelease_3_) {
        this.d_x = this.x;
        this.d_y = this.y;
    }

    @Override
    public boolean m_6375_(double x, double y, int mb) {
        if (this.hovered && mb == 0) {
            if (this.isDisableable && x >= (double)(this.x + this.width - 12) && x < (double)(this.width + this.x - 2) && y >= (double)(this.y + 2) && y < (double)(this.y + 12)) {
                this.playDownSound(Minecraft.m_91087_().m_91106_());
                this.isShow = !this.isShow;
                for (ButtonWidget.ButtonClickListener hl : this.listeners) {
                    hl.onClick(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7979_(double p_93645_, double p_93646_, int mb, double p_93648_, double p_93649_) {
        if (mb == 0) {
            this.onDrag(p_93645_, p_93646_, p_93648_, p_93649_);
            return true;
        }
        return false;
    }

    protected void onDrag(double p_onDrag_1_, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.d_x += p_onDrag_5_;
        this.d_y += p_onDrag_7_;
        Minecraft mc = Minecraft.m_91087_();
        if (!this.snapable) {
            this.x = this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.f_91080_.f_96543_ - this.getWidth()) ? mc.f_91080_.f_96543_ - this.getWidth() : (int)this.d_x);
            this.y = this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.f_91080_.f_96544_ - this.getHeight()) ? mc.f_91080_.f_96544_ - this.getHeight() : (int)this.d_y);
        } else {
            this.x = this.d_x + (double)(this.getWidth() / 2) <= (double)(mc.f_91080_.f_96543_ / 2 - 10) || this.d_x + (double)(this.getWidth() / 2) >= (double)(mc.f_91080_.f_96543_ / 2 + 10) ? (this.d_x < 0.0 ? 0 : (this.d_x > (double)(mc.f_91080_.f_96543_ - this.getWidth()) ? mc.f_91080_.f_96543_ - this.getWidth() : (int)this.d_x)) : mc.f_91080_.f_96543_ / 2 - this.getWidth() / 2;
            this.y = this.d_y + (double)(this.getHeight() / 2) <= (double)(mc.f_91080_.f_96544_ / 2 - 10) || this.d_y + (double)(this.getHeight() / 2) >= (double)(mc.f_91080_.f_96544_ / 2 + 10) ? (this.d_y < 0.0 ? 0 : (this.d_y > (double)(mc.f_91080_.f_96544_ - this.getHeight()) ? mc.f_91080_.f_96544_ - this.getHeight() : (int)this.d_y)) : mc.f_91080_.f_96544_ / 2 - this.getHeight() / 2;
        }
        for (ConfigWidgetPosListener hl : this.posListeners) {
            hl.onPosChanged(this);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static interface ConfigWidgetPosListener {
        public void onPosChanged(ConfigWidget var1);
    }
}

