/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.events;

import invtweaks.config.InvTweaksConfig;
import invtweaks.network.NetworkDispatcher;
import invtweaks.util.ClientUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="invtweaks")
public class ServerEvents {
    private static final Map<Player, EnumMap<InteractionHand, Item>> itemsCache = new WeakHashMap<Player, EnumMap<InteractionHand, Item>>();
    private static final Map<Player, Object2IntMap<Item>> usedCache = new WeakHashMap<Player, Object2IntMap<Item>>();

    private ServerEvents() {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.SERVER) {
            if (!InvTweaksConfig.getPlayerAutoRefill(event.player)) {
                return;
            }
            EnumMap cached = itemsCache.computeIfAbsent(event.player, k -> new EnumMap(InteractionHand.class));
            Object2IntMap ucached = usedCache.computeIfAbsent(event.player, k -> new Object2IntOpenHashMap());
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held;
                if (cached.get(hand) != null && event.player.m_21120_(hand).m_41619_() && ((ServerPlayer)event.player).m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)cached.get(hand)))) > ucached.getOrDefault(cached.get(hand), Integer.MAX_VALUE)) {
                    ServerEvents.searchForSubstitute(event.player, hand, (Item)cached.get(hand));
                }
                cached.put(hand, (held = event.player.m_21120_(hand)).m_41619_() ? null : held.m_41720_());
                if (held.m_41619_()) continue;
                ucached.put((Object)held.m_41720_(), ((ServerPlayer)event.player).m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)held.m_41720_())));
            }
        } else if (InvTweaksConfig.isDirty()) {
            if (ClientUtils.serverConnectionExists()) {
                NetworkDispatcher.INSTANCE.sendToServer((Object)InvTweaksConfig.getSyncPacket());
            }
            InvTweaksConfig.setDirty(false);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity() == ClientUtils.safeGetPlayer()) {
            InvTweaksConfig.setDirty(true);
        }
    }

    private static void searchForSubstitute(Player ent, InteractionHand hand, Item item) {
        IntList frozen = (IntList)Optional.ofNullable(InvTweaksConfig.getPlayerRules(ent).catToInventorySlots("/FROZEN")).map(IntArrayList::new).orElseGet(IntArrayList::new);
        frozen.sort(null);
        if (Collections.binarySearch(frozen, ent.m_150109_().f_35977_) >= 0) {
            return;
        }
        TagKey altTag = null;
        if (item instanceof TieredItem) {
            if (item instanceof SwordItem) {
                altTag = ItemTags.f_271388_;
            } else if (item instanceof PickaxeItem) {
                altTag = ItemTags.f_271360_;
            } else if (item instanceof AxeItem) {
                altTag = ItemTags.f_271207_;
            } else if (item instanceof ShovelItem) {
                altTag = ItemTags.f_271138_;
            } else if (item instanceof HoeItem) {
                altTag = ItemTags.f_271298_;
            }
        }
        TagKey finalAltTag = altTag;
        ent.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(cap -> {
            int alternativeSlot = -1;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (Collections.binarySearch(frozen, i) >= 0) continue;
                ItemStack candidate = cap.extractItem(i, Integer.MAX_VALUE, true).m_41777_();
                if (candidate.m_150930_(item)) {
                    cap.extractItem(i, Integer.MAX_VALUE, false);
                    ent.m_21008_(hand, candidate);
                    break;
                }
                if (finalAltTag == null || !candidate.m_204117_(finalAltTag)) continue;
                alternativeSlot = i;
            }
            if (alternativeSlot >= 0 && ent.m_21120_(hand).m_41619_()) {
                ent.m_21008_(hand, cap.extractItem(alternativeSlot, Integer.MAX_VALUE, false));
            }
        });
    }
}

