/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.EffectCategory;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;

public abstract class EffectInfo {
    private static final Supplier<Map<MobEffect, List<ItemStack>>> STATIC_CACHE = Suppliers.memoize(EffectInfo::buildStaticCache);
    protected final List<FormattedText> description;
    protected final MobEffectInstance effect;
    protected final List<ItemStack> inputItems;
    public static final Comparator<ItemStack> COMPARATOR = (o1, o2) -> {
        ResourceLocation r1 = BuiltInRegistries.f_257033_.m_7981_((Object)o1.m_41720_());
        ResourceLocation r2 = BuiltInRegistries.f_257033_.m_7981_((Object)o2.m_41720_());
        int i = r1.m_135827_().compareTo(r2.m_135827_());
        if (i == 0 && (i = r1.m_135815_().compareTo(r1.m_135815_())) == 0) {
            return o1.m_41611_().getString().compareTo(o2.m_41611_().getString());
        }
        return i;
    };

    protected EffectInfo(MobEffectInstance effectInstance, List<ItemStack> input, List<FormattedText> description) {
        this.description = description;
        this.effect = effectInstance;
        this.inputItems = input;
    }

    public List<ItemStack> getInputItems() {
        return this.inputItems;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    private static Map<MobEffect, List<ItemStack>> buildStaticCache() {
        HashMap<MobEffect, List<ItemStack>> effectProvidingItems = new HashMap<MobEffect, List<ItemStack>>();
        for (Block b : BuiltInRegistries.f_256975_) {
            if (!(b instanceof FlowerBlock)) continue;
            FlowerBlock flowerblock = (FlowerBlock)b;
            ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
            MobEffect effect = flowerblock.m_53521_();
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)200);
            effectProvidingItems.computeIfAbsent(effect, i -> new ItemStackList()).add(stew);
        }
        for (Item i2 : BuiltInRegistries.f_257033_) {
            FoodProperties food = i2.m_41473_();
            if (food == null) continue;
            ItemStack foodItem = new ItemStack((ItemLike)i2);
            for (Pair pair : food.m_38749_()) {
                MobEffectInstance first = (MobEffectInstance)pair.getFirst();
                if (first == null) continue;
                effectProvidingItems.computeIfAbsent(first.m_19544_(), s -> new ItemStackList()).add(foodItem);
            }
        }
        for (MobEffect[] array : BeaconBlockEntity.f_58646_) {
            for (MobEffect e : array) {
                effectProvidingItems.computeIfAbsent(e, s -> new ItemStackList()).add(Items.f_42065_.m_7968_());
            }
        }
        return effectProvidingItems;
    }

    public static List<ItemStack> computeEffectProviders(MobEffect effect) {
        List<ItemStack> stat;
        ItemStackList list = new ItemStackList();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            List recipes = world.m_7465_().m_44013_(Jeed.getEffectProviderType());
            for (EffectProviderRecipe p : recipes) {
                for (MobEffect e2 : p.getEffects()) {
                    if (e2 != effect) continue;
                    for (Ingredient i : p.m_7527_()) {
                        list.addAll(List.of(i.m_43908_()));
                    }
                }
            }
            List potionRecipes = world.m_7465_().m_44013_(Jeed.getPotionProviderType());
            for (PotionProviderRecipe p : potionRecipes) {
                List<Object> acceptablePotions = p.getPotions();
                if (acceptablePotions.isEmpty()) {
                    acceptablePotions = BuiltInRegistries.f_256980_.m_123024_().toList();
                }
                for (Potion potion : acceptablePotions) {
                    if (!potion.m_43488_().stream().anyMatch(e -> e.m_19544_() == effect)) continue;
                    for (Ingredient ing : p.m_7527_()) {
                        for (ItemStack stack : ing.m_43908_()) {
                            ItemStack copy = stack.m_41777_();
                            PotionUtils.m_43549_((ItemStack)copy, (Potion)potion);
                            list.add(copy);
                        }
                    }
                }
            }
        }
        if ((stat = STATIC_CACHE.get().get(effect)) != null) {
            list.addAll(stat);
        }
        list.sort(COMPARATOR);
        return list;
    }

    public static Component getDescription(MobEffect effect) {
        ResourceLocation name = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
        String descriptionKey = "effect." + name.m_135827_() + "." + name.m_135815_() + ".description";
        MutableComponent text = Component.m_237115_((String)descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = Component.m_237115_((String)"jeed.description.missing");
        }
        return text;
    }

    public static int getListHeight(List<ItemStack> inputs) {
        int listH = 0;
        if (Jeed.hasIngredientList() && !inputs.isEmpty()) {
            listH = EffectCategory.MAX_BOX_HEIGHT;
            if (inputs.size() <= 7) {
                listH /= 2;
            }
        }
        return listH;
    }

    private static class ItemStackList
    extends ArrayList<ItemStack> {
        @Override
        public boolean add(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            for (ItemStack thisStack : this) {
                if (!ItemStack.m_41728_((ItemStack)thisStack, (ItemStack)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }
}

