/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.forge;

import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.ScreenExtensionsHandler;
import net.mehvahdjukaar.jeed.compat.NativeCompat;
import net.mehvahdjukaar.jeed.compat.forge.StylishEffectsCompat;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class JeedClient {
    private static IEffectScreenExtension<?> currentExt = null;
    private static Screen currentScreen = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(JeedClient.class);
        NativeCompat.init();
        if (ModList.get().isLoaded("stylisheffects")) {
            StylishEffectsCompat.init();
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        currentExt = null;
        currentScreen = null;
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        JeedClient.storeExtension(event.getScreen());
    }

    private static void storeExtension(Screen screen) {
        currentExt = ScreenExtensionsHandler.getExtension(screen);
        currentScreen = currentExt != null ? screen : null;
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render event) {
        if (currentExt != null) {
            MobEffectInstance effect;
            Screen screen = event.getScreen();
            if (screen != currentScreen) {
                JeedClient.storeExtension(screen);
            }
            if (screen == currentScreen && (effect = currentExt.getEffectAtPosition(screen, event.getMouseX(), event.getMouseY(), IEffectScreenExtension.CallReason.TOOLTIP)) != null) {
                ScreenExtensionsHandler.renderEffectTooltip(effect, screen, event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), currentExt.showDurationOnTooltip());
            }
        }
    }

    @SubscribeEvent
    public static void onScreenMouseButton(ScreenEvent.MouseButtonPressed event) {
        if (currentExt != null) {
            MobEffectInstance effect;
            Screen screen = event.getScreen();
            if (screen != currentScreen) {
                JeedClient.storeExtension(screen);
            }
            if (screen == currentScreen && (effect = currentExt.getEffectAtPosition(screen, event.getMouseX(), event.getMouseY(), IEffectScreenExtension.CallReason.MOUSE_CLICKED)) != null) {
                Jeed.PLUGIN.onClickedEffect(effect, event.getMouseX(), event.getMouseY(), event.getButton());
            }
        }
    }
}

