/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.forge;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.forge.JeedClient;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="jeed")
public class JeedImpl {
    private static ForgeConfigSpec.BooleanValue effectBox;
    private static ForgeConfigSpec.BooleanValue renderSlots;
    private static ForgeConfigSpec.BooleanValue suppressVanillaTooltips;
    private static ForgeConfigSpec.BooleanValue ingredientsList;
    private static ForgeConfigSpec.BooleanValue effectColor;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenEffects;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES_SERIALIZERS;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public static final RegistryObject<RecipeType<EffectProviderRecipe>> EFFECT_PROVIDER_TYPE;
    public static final RegistryObject<RecipeType<PotionProviderRecipe>> POTION_PROVIDER_TYPE;
    public static final RegistryObject<RecipeSerializer<EffectProviderRecipe>> EFFECT_PROVIDER_SERIALIZER;
    public static final RegistryObject<RecipeSerializer<PotionProviderRecipe>> POTION_PROVIDER_SERIALIZER;

    public JeedImpl() {
        if (!(ModList.get().isLoaded("jei") || ModList.get().isLoaded("roughlyenoughitems") || ModList.get().isLoaded("emi"))) {
            Jeed.LOGGER.error("Jepp requires either JEI, REI or EMI mods. None of them was found");
        }
        Jeed.EMI = ModList.get().isLoaded("emi");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RECIPES_SERIALIZERS.register(bus);
        RECIPE_TYPES.register(bus);
        JeedImpl.createConfigs();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            JeedClient.init();
        }
    }

    private static void createConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        effectColor = builder.comment("Show effect colors in tooltip").define("effect_color", true);
        effectBox = builder.comment("Draw a black box behind effect icons").define("effect_box", true);
        hiddenEffects = builder.comment("A list of effects that should not be registered nor shown in JEI/REI. You can also use the 'hidden' mob_effect tag").defineList("hidden_effects", Collections.singletonList(""), String.class::isInstance);
        ingredientsList = builder.comment("Show ingredients list along with an effect description").define("ingredients_list", true);
        renderSlots = builder.comment("Renders individual slots instead of a big one. Only works for REI").define("render_slots", false);
        suppressVanillaTooltips = builder.comment("Removes vanilla tooltips rendered when an effect renders small (square box)").define("replace_vanilla_tooltips", true);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
    }

    public static RecipeSerializer<?> getEffectProviderSerializer() {
        return (RecipeSerializer)EFFECT_PROVIDER_SERIALIZER.get();
    }

    public static RecipeType<EffectProviderRecipe> getEffectProviderType() {
        return (RecipeType)EFFECT_PROVIDER_TYPE.get();
    }

    public static RecipeSerializer<?> getPotionProviderSerializer() {
        return (RecipeSerializer)POTION_PROVIDER_SERIALIZER.get();
    }

    public static RecipeType<PotionProviderRecipe> getPotionProviderType() {
        return (RecipeType)POTION_PROVIDER_TYPE.get();
    }

    public static Collection<String> getHiddenEffects() {
        return (Collection)hiddenEffects.get();
    }

    public static boolean hasIngredientList() {
        return (Boolean)ingredientsList.get();
    }

    public static boolean hasEffectBox() {
        return (Boolean)effectBox.get();
    }

    public static boolean hasEffectColor() {
        return (Boolean)effectColor.get();
    }

    public static boolean rendersSlots() {
        return (Boolean)renderSlots.get();
    }

    public static boolean suppressVanillaTooltips() {
        return (Boolean)suppressVanillaTooltips.get();
    }

    static {
        RECIPES_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"jeed");
        RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"jeed");
        EFFECT_PROVIDER_TYPE = RECIPE_TYPES.register("effect_provider", () -> RecipeType.simple((ResourceLocation)Jeed.res("effect_provider")));
        POTION_PROVIDER_TYPE = RECIPE_TYPES.register("potion_provider", () -> RecipeType.simple((ResourceLocation)Jeed.res("potion_provider")));
        EFFECT_PROVIDER_SERIALIZER = RECIPES_SERIALIZERS.register("effect_provider", EffectProviderRecipe.Serializer::new);
        POTION_PROVIDER_SERIALIZER = RECIPES_SERIALIZERS.register("potion_provider", PotionProviderRecipe.Serializer::new);
    }
}

