/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.EffectCategory;
import net.mehvahdjukaar.jeed.common.HSLColor;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectBox;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.plugin.jei.display.TabIcon;
import net.mehvahdjukaar.jeed.plugin.jei.ingredient.EffectInstanceRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class EffectRecipeCategory
extends EffectCategory
implements IRecipeCategory<EffectInfoRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final IDrawable effectBackground;

    public EffectRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, RECIPE_HEIGHT);
        this.effectBackground = new EffectBox();
        this.icon = new TabIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
    }

    public RecipeType<EffectInfoRecipe> getRecipeType() {
        return EffectInfoRecipe.TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(EffectInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int size;
        int xPos = 0;
        int yPos = this.effectBackground.getHeight() + 4 + 12;
        Font font = Minecraft.m_91087_().f_91062_;
        MobEffect effect = recipe.getEffect().m_19544_();
        MutableComponent name = (MutableComponent)effect.m_19482_();
        int color = HSLColor.getProcessedColor(effect.m_19484_());
        name.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)color)));
        float x = 80.0f - (float)font.m_92852_((FormattedText)name) / 2.0f;
        graphics.m_280648_(font, Language.m_128107_().m_5536_((FormattedText)name), (int)x, 0, -16777216);
        for (FormattedText descriptionLine : recipe.getDescription()) {
            graphics.m_280649_(font, Language.m_128107_().m_5536_(descriptionLine), xPos, yPos, -16777216, false);
            Objects.requireNonNull(font);
            yPos += 9 + 2;
        }
        if (Jeed.hasIngredientList() && (size = recipe.getInputItems().size()) != 0) {
            int maxSlots = size <= 7 ? 7 : 7 * ROWS;
            for (int slotId = 0; slotId < maxSlots; ++slotId) {
                int slotX = 1 + (int)(80.0f + 19.0f * ((float)(slotId % 7) - 3.5f));
                this.slotBackground.draw(graphics, slotX, RECIPE_HEIGHT - 19 * (1 + slotId / 7));
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EffectInfoRecipe recipe, IFocusGroup focuses) {
        IIngredientType<MobEffectInstance> type = JEIPlugin.EFFECT_INGREDIENT_TYPE;
        IRecipeSlotBuilder mainSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 15).setCustomRenderer(type, (IIngredientRenderer)EffectInstanceRenderer.INSTANCE_SLOT).addIngredient(type, (Object)recipe.getEffect());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient(type, (Object)recipe.getEffect());
        if (Jeed.hasEffectBox()) {
            mainSlot.setBackground(this.effectBackground, -3, -3);
        }
        if (Jeed.hasIngredientList()) {
            List<ItemStack> inputItems = recipe.getInputItems();
            ArrayList slotContents = new ArrayList();
            for (int slotId = 0; slotId < inputItems.size(); ++slotId) {
                int ind = slotId % (7 * ROWS);
                if (slotContents.size() <= ind) {
                    slotContents.add(new ArrayList());
                }
                ((List)slotContents.get(ind)).add(inputItems.get(slotId));
            }
            int r = inputItems.size() <= 7 ? 1 : ROWS;
            for (int slotId = 0; slotId < slotContents.size(); ++slotId) {
                int off = Jeed.EMI ? 1 : 0;
                int x = off + (int)(80.0f + (float)ROWS + 19.0f * ((float)(slotId % 7) - 3.5f));
                int y = 1 + RECIPE_HEIGHT - 19 * (r - slotId / 7);
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks((List)slotContents.get(slotId));
            }
        }
    }
}

