/*
 * Decompiled with CFR 0.152.
 */
package github.iri.jem.jei;

import github.iri.jem.ResourceLocationUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ModJeiPlugin
implements IModPlugin {
    private static final ResourceLocation JEI = new ResourceLocation("jerm", "jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager manager = registration.getIngredientManager();
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        registration.addRecipes(RecipeTypes.ANVIL, ModJeiPlugin.getRepairRecipes(factory, (IIngredientHelper<ItemStack>)manager.getIngredientHelper((IIngredientType)VanillaTypes.ITEM_STACK)).toList());
    }

    private static Stream<RepairData> getRepairData() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(Item::m_41465_).filter(item -> !ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("minecraft")).map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            Item repairItem = item.m_41469_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                Ingredient repairIngredient = armorItem.m_40401_().m_6230_();
                if (repairIngredient == Ingredient.f_43901_ || repairIngredient.m_43908_().length == 0) {
                    return null;
                }
                return new RepairData(repairIngredient, stack);
            }
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                Ingredient repairIngredient = tieredItem.m_43314_().m_6282_();
                if (repairIngredient == Ingredient.f_43901_ || repairIngredient.m_43908_().length == 0) {
                    return null;
                }
                return new RepairData(repairIngredient, stack);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<ItemStack> ingredientHelper) {
        return ModJeiPlugin.getRepairData().flatMap(repairData -> ModJeiPlugin.getRepairRecipes(repairData, vanillaRecipeFactory, ingredientHelper));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<ItemStack> ingredientHelper) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            String ingredientIdPath = ResourceLocationUtil.sanitizePath(ingredientHelper.getUniqueId(itemStack, UidContext.Recipe));
            String itemModId = ingredientHelper.getResourceLocation(itemStack).m_135827_();
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            List<ItemStack> damagedThreeQuartersSingletonList = List.of(damagedThreeQuarters);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damagedThreeQuartersSingletonList, damagedThreeQuartersSingletonList, List.of(damagedHalf), new ResourceLocation(itemModId, "self_repair." + ingredientIdPath));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, damagedThreeQuartersSingletonList, new ResourceLocation(itemModId, "materials_repair." + ingredientIdPath));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    public ResourceLocation getPluginUid() {
        return JEI;
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

