/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruauctions.core.gui;

import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import ru.auriny.komaruauctions.core.base.ContainerMenuBase;
import ru.auriny.komaruauctions.core.network.NetworkMessages;
import ru.auriny.komaruauctions.core.network.messages.AuctionActionPacket;
import ru.auriny.komaruauctions.core.registries.MenuRegistry;
import ru.auriny.komaruauctions.server.database.AuctionItemData;
import ru.auriny.komaruauctions.server.util.ItemDeserializer;
import ru.auriny.komarueconomy.config.Config;

public class AuctionMenu
extends ContainerMenuBase {
    public boolean isTooltipLocked = false;
    public ItemStack lockedTooltipItem = ItemStack.f_41583_;
    public int currentPage;
    public int totalPages;
    public final String searchQuery;
    public final String sellerFilter;

    public AuctionMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        super((MenuType)MenuRegistry.AUCTION_MENU.get(), id);
        SimpleContainer auctionContainer = new SimpleContainer(45){

            public boolean m_7013_(int index, @NotNull ItemStack stack) {
                return false;
            }

            public boolean m_271862_(@NotNull Container pTarget, int pIndex, @NotNull ItemStack pStack) {
                return false;
            }
        };
        int xStart = 8;
        int yStart = 24;
        int slotSize = 18;
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = xStart + col * slotSize;
                int y = yStart + row * slotSize;
                this.m_38897_(new AuctionSlot((Container)auctionContainer, row * 9 + col, x, y));
            }
        }
        if (data != null && data.readableBytes() > 0) {
            this.searchQuery = data.m_130277_();
            this.sellerFilter = data.m_130277_();
            int page = data.readInt();
            int totalPages = data.readInt();
            int itemCount = data.readInt();
            for (int i = 0; i < itemCount; ++i) {
                CompoundTag tag = data.m_130260_();
                if (tag == null) {
                    return;
                }
                int itemId = tag.m_128451_("id");
                String playerName = tag.m_128461_("playerName");
                String playerUUID = tag.m_128461_("playerUUID");
                double price = tag.m_128459_("price");
                boolean isPriority = tag.m_128471_("isPriority");
                long createdAt = tag.m_128454_("createdAt");
                AuctionItemData itemData = AuctionItemData.fromNbt((CompoundTag)tag);
                ItemStack itemStack = ItemDeserializer.deserialize((String)itemData.getSerializedItem());
                CompoundTag displayTag = itemStack.m_41698_("display");
                ListTag lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"          ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(false)).m_178522_(Boolean.valueOf(true))))));
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u041f\u0440\u043e\u0434\u0430\u0432\u0435\u0446: ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))).m_7220_((Component)Component.m_237113_((String)playerName).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(false)))))));
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u0426\u0435\u043d\u0430: ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))).m_7220_((Component)Component.m_237113_((String)(price + Config.getCurrencySymbol())).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(false)))))));
                Player player = playerInventory.f_35978_;
                if (playerName.equals(player.m_7755_().getString())) {
                    lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u042d\u0442\u043e \u0432\u0430\u0448 \u043b\u043e\u0442.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true))))));
                    lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u041b\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u0441\u043d\u044f\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0441 \u043f\u0440\u043e\u0434\u0430\u0436\u0438!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN).m_131155_(Boolean.valueOf(false))))));
                } else {
                    lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u041b\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u043a\u0443\u043f\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN).m_131155_(Boolean.valueOf(false))))));
                }
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"          ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(false)).m_178522_(Boolean.valueOf(true))))));
                displayTag.m_128365_("Lore", (Tag)lore);
                CompoundTag itemTag = itemStack.m_41784_();
                itemTag.m_128405_("id", tag.m_128451_("id"));
                itemTag.m_128359_("playerName", tag.m_128461_("playerName"));
                itemTag.m_128359_("playerUUID", tag.m_128461_("playerUUID"));
                itemTag.m_128347_("price", tag.m_128459_("price"));
                itemTag.m_128379_("isPriority", tag.m_128471_("isPriority"));
                itemTag.m_128356_("createdAt", tag.m_128454_("createdAt"));
                itemStack.m_41751_(itemTag);
                auctionContainer.m_6836_(i, itemStack);
            }
            this.currentPage = page;
            this.totalPages = totalPages;
        } else {
            this.searchQuery = "";
            this.sellerFilter = "";
            this.currentPage = 0;
            this.totalPages = 0;
        }
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.layoutPlayerInventorySlots(8, 136);
    }

    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        if (clickType != ClickType.PICKUP) {
            return;
        }
        if (slotId <= 44 && slotId < this.f_38839_.size()) {
            Slot slot = (Slot)this.f_38839_.get(slotId);
            if (!slot.m_6657_()) {
                return;
            }
            switch (button) {
                case 0: {
                    if (this.isTooltipLocked && slot.m_7993_() == this.lockedTooltipItem) {
                        CompoundTag tag = this.lockedTooltipItem.m_41783_();
                        if (tag == null) {
                            return;
                        }
                        int id = tag.m_128451_("id");
                        if (player.m_20193_().m_5776_()) {
                            NetworkMessages.CHANNEL.sendToServer((Object)new AuctionActionPacket(id));
                        }
                        player.m_216990_(new Random().nextInt(2) == 1 ? SoundEvents.f_12509_ : SoundEvents.f_12504_);
                        break;
                    }
                    this.isTooltipLocked = true;
                    this.lockedTooltipItem = slot.m_7993_();
                    player.m_216990_(SoundEvents.f_12632_);
                    break;
                }
                case 1: {
                    if (!this.isTooltipLocked) break;
                    this.isTooltipLocked = false;
                    this.lockedTooltipItem = ItemStack.f_41583_;
                    player.m_216990_(SoundEvents.f_12507_);
                    break;
                }
                default: {
                    super.m_150399_(slotId, button, clickType, player);
                }
            }
        }
    }

    @Override
    public int getInventorySize() {
        return 5;
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        return ItemStack.f_41583_;
    }

    private static class AuctionSlot
    extends Slot {
        public AuctionSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_8010_(@NotNull Player playerIn) {
            return false;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }
}

