/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruauctions.core.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;
import ru.auriny.komaruauctions.core.base.TransparentButton;
import ru.auriny.komaruauctions.core.gui.AuctionMenu;
import ru.auriny.komaruauctions.core.gui.SearchPopup;
import ru.auriny.komaruauctions.core.network.NetworkMessages;
import ru.auriny.komaruauctions.core.network.messages.ButtonClickMessage;
import ru.auriny.komaruauctions.core.network.messages.SearchMessage;

public class AuctionScreen
extends AbstractContainerScreen<AuctionMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("komaruauctions", "textures/gui/auction_menu.png");
    private SearchPopup searchField;
    private boolean isSearchActive = false;
    private long lastReloadTime = 0L;
    private String currentSearchQuery;
    private String currentSellerFilter;
    private long lastSearchTime = 0L;
    private String lastSentQuery;
    private static final int SEARCH_DELAY_MS = 1240;

    public AuctionScreen(AuctionMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 175;
        this.f_97727_ = 218;
        this.currentSearchQuery = menu.searchQuery;
        this.currentSellerFilter = menu.sellerFilter;
        this.lastSentQuery = menu.searchQuery;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = (this.f_96543_ - this.f_97726_) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)TransparentButton.builder(button -> this.handleButtonPress("back")).tooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430"))).pos(centerX + 11, centerY + 117).size(46, 16).build());
        this.m_142416_((GuiEventListener)TransparentButton.builder(button -> this.toggleSearch()).tooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u041f\u043e\u0438\u0441\u043a \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432"))).pos(centerX + 61, centerY + 117).size(16, 16).build());
        this.m_142416_((GuiEventListener)TransparentButton.builder(button -> this.handleButtonPress("add")).tooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"))).pos(centerX + 80, centerY + 117).size(16, 16).build());
        this.m_142416_((GuiEventListener)TransparentButton.builder(button -> this.handleReloadButtonPress()).tooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c"))).pos(centerX + 99, centerY + 117).size(16, 16).build());
        this.m_142416_((GuiEventListener)TransparentButton.builder(button -> this.handleButtonPress("next")).tooltip(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430"))).pos(centerX + 119, centerY + 117).size(46, 16).build());
        this.searchField = new SearchPopup(this.f_96547_, centerX + 4, centerY - 17);
        this.searchField.m_94144_(this.currentSearchQuery);
        this.searchField.m_94194_(false);
        this.searchField.m_94151_(this::onSearchChanged);
        this.m_7787_((GuiEventListener)this.searchField);
        if (!this.currentSearchQuery.isEmpty() || !this.currentSellerFilter.isEmpty()) {
            this.isSearchActive = true;
            this.searchField.m_94194_(true);
        }
    }

    private void handleReloadButtonPress() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastReloadTime >= 1000L) {
            this.lastReloadTime = currentTime;
            this.handleButtonPress("reload");
        }
    }

    public void handleButtonPress(String action) {
        NetworkMessages.CHANNEL.sendToServer((Object)new ButtonClickMessage(action, this.currentSearchQuery, this.currentSellerFilter));
    }

    private void toggleSearch() {
        this.isSearchActive = !this.isSearchActive;
        this.searchField.m_94194_(this.isSearchActive);
        if (this.isSearchActive) {
            this.m_7522_((GuiEventListener)this.searchField);
        } else {
            this.onSearchChanged("");
            this.searchField.m_94144_("");
            this.m_7522_(null);
        }
    }

    private void onSearchChanged(String query) {
        this.currentSearchQuery = query;
        this.lastSearchTime = System.currentTimeMillis();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isSearchActive && System.currentTimeMillis() - this.lastSearchTime > 1240L && !Objects.equals(this.currentSearchQuery, this.lastSentQuery)) {
            NetworkMessages.CHANNEL.sendToServer((Object)new SearchMessage(this.currentSearchQuery, this.currentSellerFilter));
            this.lastSentQuery = this.currentSearchQuery;
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isSearchActive) {
            this.searchField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isSearchActive && this.searchField.m_93696_() && this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.f_96541_ == null) {
            return false;
        }
        if (keyCode == this.f_96541_.f_91066_.f_92092_.getKey().m_84873_()) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.isSearchActive && this.searchField.m_93696_()) {
            return this.searchField.m_5534_(codePoint, modifiers) || super.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_280092_(@NotNull GuiGraphics guiGraphics, Slot slot) {
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (((AuctionMenu)this.f_97732_).isTooltipLocked && stack.equals(((AuctionMenu)this.f_97732_).lockedTooltipItem)) {
                ResourceLocation customTexture = new ResourceLocation("komaruauctions", "textures/item/confirm.png");
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)customTexture);
                guiGraphics.m_280163_(customTexture, slot.f_40220_, slot.f_40221_, 0.0f, 0.0f, 16, 16, 16, 16);
            } else {
                super.m_280092_(guiGraphics, slot);
            }
        }
    }

    protected void m_280072_(@NotNull GuiGraphics pGuiGraphics, int pX, int pY) {
        ItemStack stack;
        super.m_280072_(pGuiGraphics, pX, pY);
        if (((AuctionMenu)this.f_97732_).isTooltipLocked && this.f_97734_ != null && this.f_97734_.m_6657_() && (stack = this.f_97734_.m_7993_()).equals(((AuctionMenu)this.f_97732_).lockedTooltipItem)) {
            TooltipFlag.Default context = new TooltipFlag.Default(Minecraft.m_91087_().f_91066_.f_92125_, Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_());
            List tooltipLines = stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)context);
            List<ClientTooltipComponent> clientTooltipComponents = tooltipLines.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).toList();
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)stack, (GuiGraphics)pGuiGraphics, (int)pX, (int)pY, (int)this.f_96543_, (int)this.f_96544_, clientTooltipComponents, (Font)this.f_96547_, (ClientTooltipPositioner)DefaultTooltipPositioner.f_262752_);
            if (preEvent.isCanceled()) {
                return;
            }
            int tooltipWidth = clientTooltipComponents.stream().mapToInt(c -> c.m_142069_(this.f_96547_)).max().orElse(0);
            int tooltipHeight = clientTooltipComponents.stream().mapToInt(ClientTooltipComponent::m_142103_).sum() + 5;
            String confirm = "\u2714 \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u041b\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c";
            String decline = "\u274c \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u041f\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c";
            tooltipWidth = Math.max(tooltipWidth, Math.max(this.f_96547_.m_92895_(confirm), this.f_96547_.m_92895_(decline)));
            int customTooltipHeight = 22;
            Vector2ic tooltipPosition = DefaultTooltipPositioner.f_262752_.m_262814_(this.f_96543_, this.f_96544_, preEvent.getX(), preEvent.getY(), tooltipWidth, tooltipHeight);
            int tooltipX = tooltipPosition.x();
            int tooltipY = tooltipPosition.y() + tooltipHeight + 5;
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)pGuiGraphics, (int)tooltipX, (int)tooltipY, (int)tooltipWidth, (int)customTooltipHeight, (int)300, (int)Color.decode("#864b38").getRGB(), (int)Color.decode("#5e2f25").darker().getRGB(), (int)Color.decode("#ed2835").brighter().getRGB(), (int)Color.decode("#ed2835").getRGB());
            PoseStack poseStack = pGuiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 350.0f);
            pGuiGraphics.m_280488_(this.f_96547_, confirm, tooltipX + 1, tooltipY + 2, 2225430);
            pGuiGraphics.m_280488_(this.f_96547_, decline, tooltipX + 1, tooltipY + 12, 15542325);
            poseStack.m_85849_();
        }
    }
}

