/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruauctions.core.network;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.auriny.komaruauctions.core.network.messages.AuctionActionPacket;
import ru.auriny.komaruauctions.core.network.messages.ButtonClickMessage;
import ru.auriny.komaruauctions.core.network.messages.C2S_RespondItemNamePacket;
import ru.auriny.komaruauctions.core.network.messages.IPacket;
import ru.auriny.komaruauctions.core.network.messages.S2C_RequestItemNamePacket;
import ru.auriny.komaruauctions.core.network.messages.SearchMessage;

public class NetworkMessages {
    private static final String PROTOCOL_VERSION = "1";
    private static int packetId = 0;
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("komaruauctions", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        NetworkMessages.registerPacket(SearchMessage.class, SearchMessage::new, NetworkDirection.PLAY_TO_SERVER);
        NetworkMessages.registerPacket(ButtonClickMessage.class, ButtonClickMessage::new, NetworkDirection.PLAY_TO_SERVER);
        NetworkMessages.registerPacket(AuctionActionPacket.class, AuctionActionPacket::new, NetworkDirection.PLAY_TO_SERVER);
        NetworkMessages.registerPacket(C2S_RespondItemNamePacket.class, C2S_RespondItemNamePacket::new, NetworkDirection.PLAY_TO_SERVER);
        NetworkMessages.registerPacket(S2C_RequestItemNamePacket.class, S2C_RequestItemNamePacket::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG extends IPacket> void registerPacket(Class<MSG> messageType, IPacket.PacketFactory<MSG> factory, NetworkDirection direction) {
        CHANNEL.registerMessage(packetId++, messageType, IPacket::encode, factory::create, (msg, ctx) -> {
            ServerPlayer player = direction == NetworkDirection.PLAY_TO_SERVER ? ((NetworkEvent.Context)ctx.get()).getSender() : null;
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> msg.handle(player));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }, Optional.of(direction));
    }
}

