/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruauctions.core.network;

import java.text.NumberFormat;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import ru.auriny.komaruauctions.KomaruAuctions;
import ru.auriny.komaruauctions.core.gui.AuctionMenu;
import ru.auriny.komaruauctions.core.network.messages.AuctionActionPacket;
import ru.auriny.komaruauctions.core.network.messages.ButtonClickMessage;
import ru.auriny.komaruauctions.core.network.messages.C2S_RespondItemNamePacket;
import ru.auriny.komaruauctions.core.network.messages.SearchMessage;
import ru.auriny.komaruauctions.server.database.AuctionDao;
import ru.auriny.komaruauctions.server.database.AuctionItemData;
import ru.auriny.komaruauctions.server.registries.CommandRegistry;
import ru.auriny.komaruauctions.server.util.AuctionUtils;
import ru.auriny.komaruauctions.server.util.ItemDeserializer;
import ru.auriny.komarueconomy.config.Config;
import ru.auriny.komarueconomy.core.EconomyManager;

public class ServerPacketHandler {
    public static void handleSearchMessage(SearchMessage msg, ServerPlayer player) {
        AuctionUtils.openAuctionMenuForPlayer((ServerPlayer)player, (int)0, (String)msg.getQuery(), (String)msg.getSellerFilter());
    }

    public static void handleButtonClickMessage(ButtonClickMessage msg, ServerPlayer player) {
        Object object = player.f_36096_;
        if (!(object instanceof AuctionMenu)) {
            return;
        }
        AuctionMenu menu = (AuctionMenu)((Object)object);
        switch (msg.getAction()) {
            case "back": {
                if (menu.currentPage <= 0) break;
                AuctionUtils.openAuctionMenuForPlayer((ServerPlayer)player, (int)(menu.currentPage - 1), (String)msg.getQuery(), (String)msg.getSellerFilter());
                break;
            }
            case "next": {
                if (menu.currentPage >= menu.totalPages - 1) break;
                AuctionUtils.openAuctionMenuForPlayer((ServerPlayer)player, (int)(menu.currentPage + 1), (String)msg.getQuery(), (String)msg.getSellerFilter());
                break;
            }
            case "reload": {
                AuctionUtils.openAuctionMenuForPlayer((ServerPlayer)player, (int)menu.currentPage, (String)msg.getQuery(), (String)msg.getSellerFilter());
                break;
            }
            case "add": {
                player.m_6915_();
                player.m_213846_((Component)Component.m_237113_((String)"\u041a\u0430\u043a \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0430 \u0430\u0443\u043a\u0446\u0438\u043e\u043d?").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u00a7l1. \u00a7r\u00a77\u0412\u043e\u0437\u044c\u043c\u0438\u0442\u0435 \u0432 \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u0440\u0443\u043a\u0443 \u043f\u0440\u0435\u0434\u043c\u0435\u0442, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0430\u0442\u044c"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u00a7l2. \u00a7r\u00a77\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u00a7l/ah sell <\u0446\u0435\u043d\u0430>"));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + msg.getAction());
            }
        }
    }

    public static void handleAuctionActionPacket(AuctionActionPacket msg, ServerPlayer player) {
        AuctionItemData dao = AuctionDao.getAuctionItemById((int)msg.getAuctionItemId());
        if (dao == null) {
            return;
        }
        AuctionMenu currentMenu = null;
        if (player.f_36096_ instanceof AuctionMenu) {
            currentMenu = (AuctionMenu)player.f_36096_;
        }
        boolean success = false;
        if (dao.getPlayerName().equals(player.m_7755_().getString())) {
            if (ServerPacketHandler.isFullInventory(msg.getAuctionItemId(), player, dao)) {
                return;
            }
            player.m_213846_((Component)KomaruAuctions.prefix.m_6881_().m_7220_((Component)Component.m_237113_((String)"\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0431\u0440\u0430\u043b\u0438 \u0441\u0432\u043e\u0439 \u043b\u043e\u0442!").m_130940_(ChatFormatting.GREEN)));
            success = true;
        } else if (EconomyManager.getBalance((String)player.m_7755_().getString()) >= dao.getPrice()) {
            if (ServerPacketHandler.isFullInventory(msg.getAuctionItemId(), player, dao)) {
                return;
            }
            EconomyManager.withdraw((String)player.m_7755_().getString(), (double)dao.getPrice());
            EconomyManager.deposit((String)dao.getPlayerName(), (double)dao.getPrice());
            player.m_213846_((Component)KomaruAuctions.prefix.m_6881_().m_7220_((Component)Component.m_237113_((String)String.format("\u0412\u044b \u043f\u0440\u0438\u043e\u0431\u0440\u0435\u043b\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0443 %s \u0437\u0430 %s%s!", dao.getPlayerName(), Config.getCurrencySymbol(), NumberFormat.getInstance().format(dao.getPrice()))).m_130940_(ChatFormatting.GREEN)));
            Optional<ServerPlayer> seller = player.m_20194_().m_6846_().m_11314_().stream().filter(p -> p.m_7755_().getString().equals(dao.getPlayerName())).findFirst();
            seller.ifPresent(s -> s.m_213846_((Component)KomaruAuctions.prefix.m_6881_().m_7220_((Component)Component.m_237113_((String)String.format("%s \u043f\u0440\u0438\u043e\u0431\u0440\u0451\u043b \u0443 \u0432\u0430\u0441 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0437\u0430 %s%s!", player.m_7755_().getString(), Config.getCurrencySymbol(), NumberFormat.getInstance().format(dao.getPrice()))).m_130940_(ChatFormatting.YELLOW))));
            success = true;
        } else {
            player.m_213846_((Component)KomaruAuctions.prefix.m_6881_().m_7220_((Component)Component.m_237113_((String)"\u041d\u0430 \u0432\u0430\u0448\u0435\u043c \u0441\u0447\u0451\u0442\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432!").m_130940_(ChatFormatting.RED)));
            player.m_6915_();
        }
        if (success && currentMenu != null) {
            AuctionUtils.openAuctionMenuForPlayer((ServerPlayer)player, (int)currentMenu.currentPage, (String)currentMenu.searchQuery, (String)currentMenu.sellerFilter);
        }
    }

    public static void handleRespondItemNamePacket(C2S_RespondItemNamePacket msg, ServerPlayer player) {
        CommandRegistry.TransactionManager.completeTransaction((ServerPlayer)player, (UUID)msg.getTransactionId(), (String)msg.getOriginalName(), (String)msg.getCustomName());
    }

    private static boolean isFullInventory(int auctionItemId, ServerPlayer player, AuctionItemData dao) {
        if (player.m_150109_().m_36062_() == -1) {
            player.m_213846_((Component)KomaruAuctions.prefix.m_6881_().m_130946_("\u0412\u0430\u0448 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u043f\u043e\u043b\u043e\u043d! \u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u0435 \u043c\u0435\u0441\u0442\u043e.").m_130940_(ChatFormatting.RED));
            player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.0f);
            return true;
        }
        AuctionDao.deleteAuctionItem((int)auctionItemId);
        player.m_36356_(ItemDeserializer.deserialize((String)dao.getSerializedItem()));
        return false;
    }
}

