/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.majruszlibrary.data.IReader;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

class ReaderFloat
implements IReader<Float> {
    ReaderFloat() {
    }

    @Override
    public JsonElement writeJson(Float value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer, Float value) {
        buffer.writeFloat(value.floatValue());
    }

    @Override
    public Tag writeTag(Float value) {
        return FloatTag.m_128566_((float)value.floatValue());
    }

    @Override
    public Float readJson(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public Float readBuffer(FriendlyByteBuf buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public Float readTag(Tag tag) {
        return Float.valueOf(((NumericTag)tag).m_7057_());
    }
}

