/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class LeechEnchantment
extends Handler {
    float healthChance = 0.1f;
    float hungerChance = 0.1f;
    float effectChance = 0.1f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_MELEE_MINECRAFT).slots((List)EquipmentSlots.MAINHAND).minLevelCost(level -> 20).maxLevelCost(level -> 40);
    }

    public LeechEnchantment() {
        super(MajruszsEnchantments.LEECH, LeechEnchantment.class, false);
        OnEntityDamaged.listen(this::tryToLeechAnything).addCondition(Condition.isLogicalServer()).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.attacker));
        this.config.define("health_chance", Reader.number(), s -> Float.valueOf(this.healthChance), (s, v) -> {
            this.healthChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("hunger_chance", Reader.number(), s -> Float.valueOf(this.hungerChance), (s, v) -> {
            this.hungerChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("effect_chance", Reader.number(), s -> Float.valueOf(this.effectChance), (s, v) -> {
            this.effectChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void tryToLeechAnything(OnEntityDamaged data) {
        boolean leechedAnything = this.tryToLeech(this.healthChance, this::leechHealth, data);
        leechedAnything = this.tryToLeech(this.hungerChance, this::leechHunger, data) || leechedAnything;
        boolean bl = leechedAnything = this.tryToLeech(this.effectChance, this::leechEffect, data) || leechedAnything;
        if (leechedAnything) {
            this.spawnEffects(data);
        }
    }

    private boolean tryToLeech(float chance, Predicate<OnEntityDamaged> predicate, OnEntityDamaged data) {
        return Random.check((float)chance) && predicate.test(data);
    }

    private boolean leechHealth(OnEntityDamaged data) {
        data.target.m_6469_(data.getLevel().m_269111_().m_269425_(), 1.0f);
        data.attacker.m_5634_(1.0f);
        return true;
    }

    private boolean leechHunger(OnEntityDamaged data) {
        LivingEntity livingEntity = data.attacker;
        if (livingEntity instanceof Player) {
            Player playerAttacker = (Player)livingEntity;
            FoodData attackerFood = playerAttacker.m_36324_();
            attackerFood.m_38705_(Math.min(attackerFood.m_38702_() + 1, 20));
            LivingEntity livingEntity2 = data.target;
            if (livingEntity2 instanceof Player) {
                Player playerTarget = (Player)livingEntity2;
                FoodData targetFood = playerTarget.m_36324_();
                targetFood.m_38705_(Math.max(targetFood.m_38702_() - 1, 0));
            }
            return true;
        }
        return false;
    }

    private boolean leechEffect(OnEntityDamaged data) {
        for (MobEffectInstance effectInstance : data.target.m_21220_()) {
            MobEffect effect = effectInstance.m_19544_();
            if (!effect.m_19486_()) continue;
            int duration = Math.min(TimeHelper.toTicks((double)30.0), effectInstance.m_19557_());
            data.attacker.m_7292_(new MobEffectInstance(effect, duration, effectInstance.m_19564_()));
            data.target.m_21195_(effect);
            return true;
        }
        return false;
    }

    private void spawnEffects(OnEntityDamaged data) {
        Vec3 from = AnyPos.from((Vec3)data.attacker.m_20182_()).add((Number)0.0, (Number)((double)data.attacker.m_20206_() * 0.75), (Number)0.0).vec3();
        Vec3 to = AnyPos.from((Vec3)data.target.m_20182_()).add((Number)0.0, (Number)((double)data.target.m_20206_() * 0.75), (Number)0.0).vec3();
        ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123808_).count(Random.round((double)(AnyPos.from((Vec3)from).dist(to).floatValue() * 5.0f))).offset(ParticleEmitter.offset((float)0.05f)).position(from).emitLine((Level)data.getServerLevel(), to);
        SoundEmitter.of((SoundEvent)SoundEvents.f_11911_).volume(SoundEmitter.randomized((float)0.25f)).position(from).emit((Level)data.getServerLevel());
    }
}

