/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.mixininterfaces.IMixinProjectile;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import com.majruszsenchantments.particles.TelekinesisParticleType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class TelekinesisEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_TOOL).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public TelekinesisEnchantment() {
        super(MajruszsEnchantments.TELEKINESIS, TelekinesisEnchantment.class, false);
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (Player)data.entity)).priority(Priority.LOWEST).addCondition(data -> data.entity instanceof Player).addCondition(data -> data.origin != null).addCondition(data -> data.tool != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.tool));
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (Player)data.killer)).priority(Priority.LOWEST).addCondition(data -> data.killer instanceof Player).addCondition(data -> data.origin != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)((Player)data.killer)));
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (Player)data.killer)).priority(Priority.LOWEST).addCondition(data -> data.killer instanceof Player).addCondition(data -> data.origin != null).addCondition(data -> data.damageSource != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)IMixinProjectile.majruszlibrary$getProjectileWeapon((Entity)data.damageSource.m_7640_())));
    }

    private void addToInventory(OnLootGenerated data, Player player) {
        if (!data.generatedLoot.removeIf(arg_0 -> ((Player)player).m_36356_(arg_0))) {
            return;
        }
        SoundEmitter.of((SoundEvent)SoundEvents.f_12019_).volume(SoundEmitter.randomized((float)0.25f)).position(player.m_20182_()).emit((Level)data.getServerLevel());
        Vec3 from = AnyPos.from((Vec3)data.origin).add((Number)0.0, (Number)(data.killer != null && data.entity != null ? (double)data.entity.m_20206_() * 0.75 : 0.0), (Number)0.0).vec3();
        Vec3 to = AnyPos.from((Vec3)player.m_20182_()).add((Number)0.0, (Number)((double)player.m_20206_() * 0.5), (Number)0.0).vec3();
        AtomicInteger idx = new AtomicInteger();
        double distance = to.m_82554_(from);
        int count = Random.round((double)(to.m_82554_(from) * 6.0));
        int lifetime = TimeHelper.toTicks((double)0.5) + Random.round((double)(distance * 0.2));
        float pulseSpeed = (float)(1.0 + (double)0.05f * distance);
        ParticleEmitter.of(() -> new TelekinesisParticleType.Options((int)((float)lifetime * ((float)count - 1.0f * (float)idx.getAndUpdate(x -> x + 1)) / (float)count), lifetime, pulseSpeed)).offset(() -> new Vec3(0.0, 0.0, 0.0)).speed(0.0f).count(count).position(from).emitLine((Level)data.getServerLevel(), to);
    }
}

