/*
 * Decompiled with CFR 0.152.
 */
package net.tschipcraft.make_bubbles_pop.impl;

import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPop;
import net.tschipcraft.make_bubbles_pop.MakeBubblesPopConfig;

@OnlyIn(value=Dist.CLIENT)
public class BubbleUtil {
    private BubbleUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void popBubble(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        if (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.POP_PARTICLE_ENABLED) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, !MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.POPPED_BUBBLES_MAINTAIN_VELOCITY ? velocityX : 0.0, !MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.POPPED_BUBBLES_MAINTAIN_VELOCITY ? velocityY : 0.0, !MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.POPPED_BUBBLES_MAINTAIN_VELOCITY ? velocityZ : 0.0);
            world.m_7785_(x, y, z, SoundEvents.f_11773_, SoundSource.AMBIENT, (MakeBubblesPop.MIDNIGHTLIB_INSTALLED ? MakeBubblesPopConfig.BUBBLE_POP_VOLUME : 0.1f) - world.f_46441_.m_188501_() * 0.1f, 0.85f + world.f_46441_.m_188501_() * 0.3f, false);
        }
    }

    public static void tintBubble(Level world, double x, double y, double z, TextureSheetParticle particle) {
        if (!MakeBubblesPop.MIDNIGHTLIB_INSTALLED || MakeBubblesPopConfig.BIOME_COLORS_ENABLED) {
            int waterColor = BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
            float intensity = MakeBubblesPop.MIDNIGHTLIB_INSTALLED ? MakeBubblesPopConfig.BIOME_COLOR_INTENSITY : 0.65f;
            float whiteMix = 1.0f - intensity;
            float cr = whiteMix + intensity * ((float)(waterColor >> 16 & 0xFF) / 255.0f);
            float cg = whiteMix + intensity * ((float)(waterColor >> 8 & 0xFF) / 255.0f);
            float cb = whiteMix + intensity * ((float)(waterColor & 0xFF) / 255.0f);
            particle.m_107253_(cr, cg, cb);
        }
    }
}

