/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.mhintegration;

import com.idark.valoria.util.Pal;
import com.minecraftserverzone.mobhealthbar.ForgeRegistryEvents;
import com.minecraftserverzone.mobhealthbar.configs.ConfigHolder;
import com.minecraftserverzone.mobhealthbar.configs.HpBarModConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.render.DotRenderType;
import pro.komaru.tridot.client.render.RenderBuilder;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import ru.auriny.omegatalents.network.PacketHandler;
import ru.auriny.omegatalents.network.RequestPlayerDataPacket;
import ru.auriny.omegatalents.utils.PlayerUpgradeData;

@Mod(value="mhintegration")
public class MHIntegration {
    public static final String MODID = "mhintegration";
    private final Map<UUID, Long> lastRequestTimes = new HashMap<UUID, Long>();
    private static final long REFRESH_INTERVAL_MS = 20000L;
    DotRenderType TRANSLUCENT_TEXTURE_DEPTH = DotRenderType.createRenderType((String)"tridot:translucent_texture_depth", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(TridotRenderTypes.COLOR_WRITE).m_110671_(TridotRenderTypes.LIGHTMAP).m_110685_(TridotRenderTypes.NORMAL_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)TridotRenderTypes.BLOCK_SHEET).m_173292_(TridotRenderTypes.TRANSLUCENT_TEXTURE_SHADER).m_110663_(new RenderStateShard.DepthTestStateShard("<=", 515)).m_110687_(new RenderStateShard.WriteMaskStateShard(true, true)).m_110691_(true));

    public MHIntegration() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderNameTag(RenderNameTagEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).m_20197_().isEmpty() && !player.m_20145_()) {
            boolean shouldRenderIcon;
            String[] blacklist;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            if (player.m_20148_().equals(minecraft.f_91074_.m_20148_()) && minecraft.f_91066_.m_92176_().m_90612_()) {
                return;
            }
            float health = player.m_21223_();
            float maxhealth = player.m_21233_();
            double distanceSq = minecraft.m_91290_().m_114471_((Entity)player);
            boolean aggressiveOnly = (Boolean)ConfigHolder.COMMON.SHOW_ON_AGGRO.get();
            boolean damaged = (Boolean)ConfigHolder.COMMON.SHOW_DAMAGED.get() != false && health < maxhealth;
            boolean hoveredOver = (Boolean)ConfigHolder.COMMON.SHOW_HOVERED_MOB.get();
            boolean showHoveredOverMob = hoveredOver && ForgeRegistryEvents.crosshairPickEntity == player;
            boolean shouldShowMob = true;
            for (String list : blacklist = ((String)HpBarModConfig.BLACKLIST.get()).split(",")) {
                if (!player.m_6095_().m_204041_().m_205785_().m_135782_().toString().equals(list)) continue;
                shouldShowMob = false;
            }
            boolean bl = shouldRenderIcon = hoveredOver && showHoveredOverMob || (damaged || (Boolean)ConfigHolder.COMMON.SHOW_DAMAGED.get() == false && !aggressiveOnly && !hoveredOver) && shouldShowMob && ForgeRegistryEvents.isNameplateInRenderDistance((Entity)player, (double)distanceSq) && (Boolean)HpBarModConfig.TOGGLE_HP_BARS.get() != false;
            if (shouldRenderIcon) {
                int lvl;
                int tier;
                event.getEntity().m_20340_(false);
                event.setResult(Event.Result.DENY);
                long currentTime = System.currentTimeMillis();
                long lastRequest = this.lastRequestTimes.getOrDefault(player.m_20148_(), 0L);
                if (currentTime - lastRequest > 20000L) {
                    PacketHandler.sendToServer((Object)new RequestPlayerDataPacket(player.m_20148_()));
                    this.lastRequestTimes.put(player.m_20148_(), currentTime);
                }
                int n = tier = (lvl = PlayerUpgradeData.getTotalLevel((Player)player)) == 0 ? 1 : lvl / 5 + 2;
                if (tier > 8) {
                    tier = 8;
                }
                PoseStack poseStack = event.getPoseStack();
                float playerHeight = player.m_20206_();
                int packedLight = 0xF000F0;
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, (double)(playerHeight + 1.325f), 0.0);
                poseStack.m_252781_(minecraft.m_91290_().m_253208_());
                poseStack.m_85841_(-0.02f, -0.02f, 0.02f);
                RenderBuilder.create().setRenderType((RenderType)this.TRANSLUCENT_TEXTURE_DEPTH).setUV(Utils.Render.getSprite((String)MODID, (String)("block/tier_" + tier))).setLight(packedLight).setColor(1.0f, 1.0f, 1.0f).setAlpha(1.0f).renderCenteredQuad(poseStack, 20.0f).endBatch();
                poseStack.m_252880_(0.0f, 0.0f, -0.001f);
                String text = String.valueOf(lvl);
                Font font = minecraft.f_91062_;
                MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
                float textX = (float)(-font.m_92895_(text)) / 2.0f + 0.5f;
                float textY = switch (tier) {
                    case 1 -> 6.35f;
                    case 2 -> 5.0f;
                    case 3 -> 4.95f;
                    case 4 -> 4.85f;
                    case 5 -> 4.25f;
                    case 6 -> 2.65f;
                    default -> 2.0f;
                };
                font.m_272077_((Component)Component.m_237113_((String)text), textX, textY, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, packedLight);
                buffer.m_109911_();
                poseStack.m_85849_();
                switch (tier) {
                    case 8: {
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.25f, 0.0f, 0.0f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, -0.25f, 0.0f, 0.0f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.0f, 0.0f, 0.25f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.0f, 0.0f, -0.25f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.17f, 0.0f, 0.17f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.17f, 0.0f, -0.17f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, -0.17f, 0.0f, 0.17f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, -0.17f, 0.0f, -0.17f, 2.0f, Pal.darkRed, 0.35f, 0.15f, 1.0f);
                        break;
                    }
                    case 7: {
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.2f, 0.0f, 0.0f, 1.8f, Pal.majestyPurple, 0.2f, 0.0f, 0.8f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, -0.2f, 0.0f, 0.0f, 1.8f, Pal.majestyPurple, 0.2f, 0.0f, 0.8f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.0f, 0.0f, 0.2f, 1.8f, Pal.majestyPurple, 0.2f, 0.0f, 0.8f);
                        MHIntegration.addParticleImitation(poseStack, playerHeight, 0.0f, 0.0f, -0.2f, 1.8f, Pal.majestyPurple, 0.2f, 0.0f, 0.8f);
                    }
                }
            }
        }
    }

    private static void addParticleImitation(PoseStack poseStack, float playerHeight, float x, float y, float z, float size, Col color, float orbitRadius, float yBob, float speed) {
        Minecraft mc = Minecraft.m_91087_();
        float partialTicks = mc.getPartialTick();
        float duration = 120.0f;
        float timeOffset = (x * 31.0f + z * 17.0f) * 20.0f;
        float time = (float)ClientTick.ticksInGame + partialTicks + timeOffset;
        float life = time % duration / duration;
        float alpha = Mth.m_14031_((float)(life * (float)Math.PI));
        float scale = (0.3f + 0.7f * Mth.m_14031_((float)(life * (float)Math.PI))) * -0.025f;
        double xOffset = x + Mth.m_14031_((float)(time * 0.04f * speed)) * orbitRadius;
        double yOffset = y + playerHeight + 1.45f + Mth.m_14089_((float)(time * 0.05f * speed)) * yBob;
        double zOffset = z + Mth.m_14089_((float)(time * 0.04f * speed)) * orbitRadius;
        poseStack.m_85836_();
        poseStack.m_85837_(xOffset, yOffset, zOffset);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(scale, scale, scale);
        RenderBuilder.create().setRenderType(TridotRenderTypes.TRANSLUCENT_TEXTURE).setUV(Utils.Render.getSprite((String)"valoria", (String)"particle/smoke")).setColor(color).setAlpha(alpha).renderCenteredQuad(poseStack, size).endBatch();
        poseStack.m_85849_();
    }
}

