/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.mhintegration.mixin;

import com.minecraftserverzone.mobhealthbar.ForgeRegistryEvents;
import com.minecraftserverzone.mobhealthbar.GuiHelper;
import com.minecraftserverzone.mobhealthbar.configs.ConfigHolder;
import com.minecraftserverzone.mobhealthbar.configs.HpBarModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeRegistryEvents.class})
public class ForgeRegistryEventsMixin {
    @Redirect(method={"renderHpBar"}, at=@At(value="INVOKE", target="Lcom/minecraftserverzone/mobhealthbar/GuiHelper;drawString(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=0), remap=false)
    private static void fixNameAlignment(PoseStack matrixStack, Font font, String text, int x, int y, int color, boolean shadow) {
        int correctedX = x + 2;
        GuiHelper.drawString((PoseStack)matrixStack, (Font)font, (String)text, (int)correctedX, (int)y, (int)color, (boolean)shadow);
    }

    @Inject(method={"renderHpBar"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void onRenderHpBarHead(RenderNameTagEvent event, CallbackInfo ci) {
        boolean shouldRenderHealthBar;
        String[] blacklist;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        float health = livingEntity.m_21223_();
        float maxhealth = livingEntity.m_21233_();
        double d01 = Minecraft.m_91087_().m_91290_().m_114471_(entity);
        boolean aggressiveOnly = (Boolean)ConfigHolder.COMMON.SHOW_ON_AGGRO.get();
        boolean damaged = (Boolean)ConfigHolder.COMMON.SHOW_DAMAGED.get() != false && health < maxhealth;
        boolean showAggressiveMob = aggressiveOnly && entity instanceof Mob && ((Mob)entity).m_5912_();
        boolean hoveredOver = (Boolean)ConfigHolder.COMMON.SHOW_HOVERED_MOB.get();
        boolean showHoveredOverMob = hoveredOver && ForgeRegistryEvents.crosshairPickEntity == entity;
        boolean shouldShowMob = true;
        for (String list : blacklist = ((String)HpBarModConfig.BLACKLIST.get()).split(",")) {
            if (!entity.m_6095_().m_204041_().m_205785_().m_135782_().toString().equals(list)) continue;
            shouldShowMob = false;
            break;
        }
        boolean bl = shouldRenderHealthBar = hoveredOver && showHoveredOverMob || (damaged || aggressiveOnly && showAggressiveMob || (Boolean)ConfigHolder.COMMON.SHOW_DAMAGED.get() == false && !aggressiveOnly && !hoveredOver) && shouldShowMob && ForgeRegistryEvents.isNameplateInRenderDistance((Entity)entity, (double)d01) && (Boolean)HpBarModConfig.TOGGLE_HP_BARS.get() != false;
        if (!shouldRenderHealthBar) {
            boolean isPlayerBlacklisted = false;
            if (entity instanceof Player) {
                for (String list : blacklist) {
                    if (!list.trim().equals("minecraft:player")) continue;
                    isPlayerBlacklisted = true;
                    break;
                }
            }
            if (isPlayerBlacklisted) {
                event.setResult(Event.Result.DENY);
            }
            ci.cancel();
        }
    }
}

