/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.mobhealthbar.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public final class ClientConfig {
    public final ForgeConfigSpec.IntValue[] HP_BAR_TYPE = new ForgeConfigSpec.IntValue[4];
    public final ForgeConfigSpec.DoubleValue[] HP_BAR_SCALE = new ForgeConfigSpec.DoubleValue[3];
    public final ForgeConfigSpec.BooleanValue TOGGLE_HP_BARS;
    public final ForgeConfigSpec.BooleanValue RENDER_ONLY_WHEN_VISIBLE;
    public final ForgeConfigSpec.BooleanValue SHOW_HP;
    public final ForgeConfigSpec.BooleanValue SHOW_NAME;
    public final ForgeConfigSpec.BooleanValue SHOW_ON_AGGRO;
    public final ForgeConfigSpec.BooleanValue SHOW_BAR;
    public final ForgeConfigSpec.BooleanValue SHOW_DAMAGED;
    public final ForgeConfigSpec.BooleanValue SHOW_HOVERED_MOB;
    public final ForgeConfigSpec.ConfigValue<String> BLACKLIST;

    ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.TOGGLE_HP_BARS = builder.comment("Toggle Health bars for mobs").translation("mobhealthbar.config.mhb.toggle").define("toogle", true);
        this.RENDER_ONLY_WHEN_VISIBLE = builder.comment("Render health bar only when the mob is visible").translation("mobhealthbar.config.mhb.visible").define("onvisible", true);
        this.SHOW_HP = builder.comment("Show health points on bars. Note that not every type of the bars can show the hp").translation("mobhealthbar.config.mhb.show_hp").define("show_hp", true);
        this.SHOW_NAME = builder.comment("Show the Name above the mobs").translation("mobhealthbar.config.mhb.show_name").define("show_name", true);
        this.SHOW_ON_AGGRO = builder.comment("Show bars only when a mob is aggressive").translation("mobhealthbar.config.mhb.on_aggro").define("on_aggro", false);
        this.SHOW_BAR = builder.comment("Show bar texture").translation("mobhealthbar.config.mhb.bar").define("bar", true);
        this.SHOW_DAMAGED = builder.comment("Show the hp bar of the mobs who are damaged").translation("mobhealthbar.config.mhb.damaged_only").define("damaged_only", false);
        this.SHOW_HOVERED_MOB = builder.comment("Show the hp bar of the mob you are looking at").translation("mobhealthbar.config.mhb.hovered_only").define("hovered_only", false);
        ClientConfig.initMobSpawnRate(builder, "MobHealtBar", "hpbar", this.HP_BAR_TYPE, this.HP_BAR_SCALE);
        this.BLACKLIST = builder.comment("\nList for the mobs that should not be displayed, put a comma (,) between the registered names!").define("blacklist", (Object)"minecraft:ender_dragon");
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, ForgeConfigSpec.IntValue[] array, ForgeConfigSpec.DoubleValue[] scale) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Health Bar Type").translation("mobhealthbar.config.type").defineInRange("type", 1, 1, 14);
        array[1] = builder.comment("X Position").translation("mobhealthbar.config.xpos").defineInRange("x-pos", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[2] = builder.comment("Y Position").translation("mobhealthbar.config.ypos").defineInRange("y-pos", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        array[3] = builder.comment("Render Distance").translation("mobhealthbar.config.rendis").defineInRange("render-distance", 2000, 0, Integer.MAX_VALUE);
        scale[0] = builder.comment("Scale Nametag").translation("mobhealthbar.config." + pushname + ".scale-name").defineInRange("scale-name", 1.0, 0.0, Double.MAX_VALUE);
        scale[1] = builder.comment("Scale Bar").translation("mobhealthbar.config." + pushname + ".scale-bar").defineInRange("scale-bar", 1.0, 0.0, Double.MAX_VALUE);
        scale[2] = builder.comment("Scale Numbers").translation("mobhealthbar.config." + pushname + ".scale-nums").defineInRange("scale-nums", 1.0, 0.0, Double.MAX_VALUE);
        builder.pop();
    }
}

