/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.management.openmbean.InvalidOpenTypeException;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.recipe.TemplateRecipeManager;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RPUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeJson(JsonElement json) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject deserializeJson(InputStream stream) {
        return GsonHelper.m_13859_((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block) throws FileNotFoundException {
        return RPUtils.findFirstBlockTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((ItemLike)block, texturePredicate);
        if (cached != null) {
            return new ResourceLocation(cached);
        }
        ResourceLocation res = Utils.getID(block);
        Optional blockState = manager.m_213713_(ResType.BLOCKSTATES.getPath(res));
        try (InputStream bsStream2 = ((Resource)blockState.orElseThrow()).m_215507_();){
            JsonObject bsElement = RPUtils.deserializeJson(bsStream2);
            Set<String> models = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model"));
            for (String modelPath : models) {
                List<String> textures = RPUtils.findAllTexturesInModelRecursive(manager, modelPath);
                for (String t : textures) {
                    TextureCache.add((ItemLike)block, t);
                    if (!texturePredicate.test(t)) continue;
                    ResourceLocation resourceLocation = new ResourceLocation(t);
                    return resourceLocation;
                }
            }
        }
        catch (Exception bsStream2) {
            // empty catch block
        }
        List<String> hack = RPUtils.guessTextureLocation(res, manager, block);
        for (String t : hack) {
            TextureCache.add((ItemLike)block, t);
            if (!texturePredicate.test(t)) continue;
            return new ResourceLocation(t);
        }
        throw new FileNotFoundException("Could not find any texture associated to the given block " + res);
    }

    private static List<String> guessTextureLocation(ResourceLocation id, ResourceManager manager, Block block) {
        String name = id.m_135815_();
        ArrayList<String> textures = new ArrayList<String>();
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            if (!name.contains(w.id.m_135815_())) continue;
            for (Map.Entry<String, Object> c : w.getChildren()) {
                if (c.getValue() != block) continue;
                if (Objects.equals(c.getKey(), "log") || c.getKey().equals("stripped_log")) {
                    textures.add(id.m_135827_() + ":block/" + name + "_top");
                    textures.add(id.m_135827_() + ":block/" + name + "_side");
                } else {
                    textures.add(id.m_135827_() + ":block/" + name);
                }
                return textures;
            }
        }
        return List.of();
    }

    @NotNull
    private static List<String> findAllTexturesInModelRecursive(ResourceManager manager, String modelPath) throws Exception {
        JsonObject modelElement;
        try (InputStream modelStream = ((Resource)manager.m_213713_(ResType.MODELS.getPath(modelPath)).get()).m_215507_();){
            modelElement = RPUtils.deserializeJson(modelStream).getAsJsonObject();
        }
        catch (Exception e) {
            throw new Exception("Failed to parse model at " + modelPath);
        }
        ArrayList<String> textures = new ArrayList<String>(RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject("textures")));
        if (textures.isEmpty() && modelElement.has("parent")) {
            String parentPath = modelElement.get("parent").getAsString();
            textures.addAll(RPUtils.findAllTexturesInModelRecursive(manager, parentPath));
        }
        return textures;
    }

    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item block) throws FileNotFoundException {
        return RPUtils.findFirstItemTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item item, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((ItemLike)item, texturePredicate);
        if (cached != null) {
            return new ResourceLocation(cached);
        }
        ResourceLocation res = Utils.getID(item);
        Optional itemModel = manager.m_213713_(ResType.ITEM_MODELS.getPath(res));
        try (InputStream stream = ((Resource)itemModel.get()).m_215507_();){
            String t;
            JsonObject bsElement = RPUtils.deserializeJson(stream);
            Set<String> textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures"));
            Iterator<String> iterator = textures.iterator();
            do {
                if (!iterator.hasNext()) throw new FileNotFoundException("Could not find any texture associated to the given item " + res);
                t = iterator.next();
                TextureCache.add((ItemLike)item, t);
            } while (!texturePredicate.test(t));
            ResourceLocation resourceLocation = new ResourceLocation(t);
            return resourceLocation;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException("Could not find any texture associated to the given item " + res);
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            HashSet<String> list = new HashSet<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e, filter)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            HashSet<String> list = new HashSet<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                Set<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return Set.of(element.getAsString());
    }

    public static Recipe<?> readRecipe(ResourceManager manager, String location) {
        return RPUtils.readRecipe(manager, ResType.RECIPES.getPath(location));
    }

    public static Recipe<?> readRecipe(ResourceManager manager, ResourceLocation location) {
        Recipe recipe;
        block8: {
            Optional resource = manager.m_213713_(location);
            InputStream stream = ((Resource)resource.orElseThrow()).m_215507_();
            try {
                JsonObject element = RPUtils.deserializeJson(stream);
                recipe = RecipeManager.m_44045_((ResourceLocation)location, (JsonObject)element);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
                }
            }
            stream.close();
        }
        return recipe;
    }

    public static IRecipeTemplate<?> readRecipeAsTemplate(ResourceManager manager, String location) {
        return RPUtils.readRecipeAsTemplate(manager, ResType.RECIPES.getPath(location));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static IRecipeTemplate<?> readRecipeAsTemplate(ResourceManager manager, ResourceLocation location) {
        Optional resource = manager.m_213713_(location);
        try (InputStream stream = ((Resource)resource.orElseThrow()).m_215507_();){
            JsonObject element = RPUtils.deserializeJson(stream);
            try {
                IRecipeTemplate<?> iRecipeTemplate = TemplateRecipeManager.read(element);
                return iRecipeTemplate;
            }
            catch (Exception e) {
                Moonlight.LOGGER.error((Object)element);
                Moonlight.LOGGER.error((Object)location);
                throw e;
            }
        }
        catch (Exception e) {
            throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
        }
    }

    public static <T extends BlockType> Recipe<?> makeSimilarRecipe(Recipe<?> original, T originalMat, T destinationMat, String baseID) {
        if (original instanceof ShapedRecipe) {
            ShapedRecipe or = (ShapedRecipe)original;
            ArrayList<Ingredient> newList = new ArrayList<Ingredient>();
            for (Ingredient ingredient : or.m_7527_()) {
                Item i;
                if (ingredient == null || ingredient.m_43908_().length <= 0 || (i = BlockType.changeItemType(ingredient.m_43908_()[0].m_41720_(), originalMat, destinationMat)) == null) continue;
                newList.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
            }
            Item originalRes = or.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_();
            Item newRes = BlockType.changeItemType(originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            ItemStack result = newRes.m_5456_().m_7968_();
            ResourceLocation newId = new ResourceLocation(baseID + "/" + destinationMat.getAppendableId());
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
            return new ShapedRecipe(newId, or.m_6076_(), or.m_245232_(), or.m_44220_(), or.m_44221_(), ingredients, result);
        }
        if (original instanceof ShapelessRecipe) {
            ShapelessRecipe or = (ShapelessRecipe)original;
            ArrayList<Ingredient> newList = new ArrayList<Ingredient>();
            for (Ingredient ingredient : or.m_7527_()) {
                Item i;
                if (ingredient == null || ingredient.m_43908_().length <= 0 || (i = BlockType.changeItemType(ingredient.m_43908_()[0].m_41720_(), originalMat, destinationMat)) == null) continue;
                newList.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
            }
            Iterator originalRes = or.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_();
            Item newRes = BlockType.changeItemType((Item)originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            ItemStack result = newRes.m_5456_().m_7968_();
            ResourceLocation newId = new ResourceLocation(baseID + "/" + destinationMat.getAppendableId());
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
            return new ShapelessRecipe(newId, or.m_6076_(), or.m_245232_(), result, ingredients);
        }
        throw new UnsupportedOperationException(String.format("Original recipe %s must be Shaped or Shapeless", original));
    }

    public static void appendModelOverride(ResourceManager manager, DynamicTexturePack pack, ResourceLocation modelRes, Consumer<OverrideAppender> modelConsumer) {
        Optional o = manager.m_213713_(ResType.ITEM_MODELS.getPath(modelRes));
        if (o.isPresent()) {
            try (InputStream model = ((Resource)o.get()).m_215507_();){
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.has("overrides") ? json.getAsJsonArray("overrides") : new JsonArray();
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                pack.addItemModel(modelRes, (JsonElement)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JsonObject serializeOverride(ItemOverride override) {
        JsonObject json = new JsonObject();
        json.addProperty("model", override.m_111718_().toString());
        JsonObject predicates = new JsonObject();
        override.m_173449_().forEach(p -> predicates.addProperty(p.m_173459_().toString(), (Number)Float.valueOf(p.m_173460_())));
        json.add("predicate", (JsonElement)predicates);
        return json;
    }

    @FunctionalInterface
    public static interface OverrideAppender {
        public void add(ItemOverride var1);
    }
}

