/*
 * Decompiled with CFR 0.152.
 */
package dev.mtechlab.mtechlabminimapadditions.packet;

import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;

public class WaypointPacket {
    public int x;
    public int y;
    public int z;
    public String name;
    public String symbol;
    public int color;
    public boolean isRemoving;

    public WaypointPacket(int x, int y, int z, String name, String symbol, int color, boolean isRemoving) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.symbol = symbol;
        this.color = color;
        this.isRemoving = isRemoving;
    }

    public WaypointPacket(FriendlyByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.symbol = buf.m_130136_(Short.MAX_VALUE);
        this.color = buf.readInt();
        this.isRemoving = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.m_130070_(this.name);
        buf.m_130070_(this.symbol);
        buf.writeInt(this.color);
        buf.writeBoolean(this.isRemoving);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            try {
                if (this.isRemoving) {
                    XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
                    minimapSession.getWaypointsManager().getWaypoints().getList().removeIf(waypoint -> waypoint.getX() == this.x && waypoint.getY() == this.y && waypoint.getZ() == this.z && waypoint.getName().equals(this.name));
                    minimapSession.getWaypointsManager().updateWaypoints();
                    minimapSession.getModMain().getSettings().saveAllWaypoints(minimapSession.getWaypointsManager());
                } else {
                    XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
                    Waypoint newWaypoint = new Waypoint(this.x, this.y, this.z, this.name, this.symbol, this.color);
                    minimapSession.getWaypointsManager().getWaypoints().getList().add(newWaypoint);
                    minimapSession.getWaypointsManager().updateWaypoints();
                    minimapSession.getModMain().getSettings().saveAllWaypoints(minimapSession.getWaypointsManager());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        context.setPacketHandled(true);
    }
}

