/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer;

import com.matyrobbrt.okzoomer.APIImpl;
import com.matyrobbrt.okzoomer.ZoomKeyBinds;
import com.matyrobbrt.okzoomer.api.ZoomInstance;
import com.matyrobbrt.okzoomer.api.ZoomOverlay;
import com.matyrobbrt.okzoomer.config.ClientConfig;
import com.matyrobbrt.okzoomer.config.ConfigEnums;
import com.matyrobbrt.okzoomer.events.ManageKeyBindsEvent;
import com.matyrobbrt.okzoomer.events.ManageZoomEvent;
import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import com.matyrobbrt.okzoomer.utils.SpyglassHelper;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="okzoomer", value={Dist.CLIENT})
public class OkZoomerClient {
    private static boolean shouldCancelOverlay;
    private static final ResourceLocation OVERLAY_NAME;
    private static final Component TOAST_TITLE;

    @SubscribeEvent
    static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll(OVERLAY_NAME.m_135815_(), (gui, poseStack, partialTick, width, height) -> {
            shouldCancelOverlay = false;
            for (ZoomInstance instance : APIImpl.getZoomInstances()) {
                ZoomOverlay overlay = instance.getZoomOverlay();
                if (overlay == null) continue;
                overlay.tickBeforeRender();
                if (!overlay.getActive()) continue;
                if (!overlay.cancelOverlayRendering()) {
                    // empty if block
                }
                shouldCancelOverlay = true;
                overlay.renderOverlay();
            }
        });
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(OkZoomerClient::clientTick);
        MinecraftForge.EVENT_BUS.addListener(OkZoomerClient::onMouseInput);
        MinecraftForge.EVENT_BUS.addListener(OkZoomerClient::renderOverlay);
        MinecraftForge.EVENT_BUS.addListener(OkZoomerClient::onMouseScroll);
        ItemProperties.registerGeneric((ResourceLocation)new ResourceLocation("okzoomer", "scoping"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(stack, clientWorld, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && entity.m_21211_().m_204117_(SpyglassHelper.SPYGLASSES) ? 1.0f : 0.0f));
        OkZoomerNetwork.configureZoomInstance();
    }

    @SubscribeEvent
    static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(ZoomKeyBinds.ZOOM_KEY);
        event.register(ZoomKeyBinds.DECREASE_ZOOM_KEY);
        event.register(ZoomKeyBinds.INCREASE_ZOOM_KEY);
        event.register(ZoomKeyBinds.RESET_ZOOM_KEY);
    }

    static void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        block5: {
            boolean enable;
            block6: {
                if (Minecraft.m_91087_().f_91073_ == null) {
                    return;
                }
                if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.SPYGLASS.id())) break block5;
                enable = !shouldCancelOverlay;
                switch (OkZoomerNetwork.getSpyglassDependency()) {
                    case REPLACE_ZOOM: 
                    case BOTH: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                enable = false;
            }
            if (!enable) {
                event.setCanceled(true);
            }
        }
    }

    static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ManageKeyBindsEvent.onTickEnd();
        ManageZoomEvent.endTick(Minecraft.m_91087_());
    }

    static void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (((Boolean)ClientConfig.ALLOW_SCROLLING.get()).booleanValue() && !OkZoomerNetwork.getDisableZoomScrolling()) {
            if (((ConfigEnums.ZoomModes)((Object)ClientConfig.ZOOM_MODE.get())).equals((Object)ConfigEnums.ZoomModes.PERSISTENT) && !ZoomKeyBinds.ZOOM_KEY.m_90857_()) {
                return;
            }
            if (event.getButton() == 2 && ZoomKeyBinds.ZOOM_KEY.m_90857_() && ((Boolean)ClientConfig.RESET_ZOOM_WITH_MOUSE.get()).booleanValue()) {
                ZoomUtils.resetZoomDivisor(true);
            }
        }
    }

    static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (((Boolean)ClientConfig.ALLOW_SCROLLING.get()).booleanValue() && !OkZoomerNetwork.getDisableZoomScrolling()) {
            if (((ConfigEnums.ZoomModes)((Object)ClientConfig.ZOOM_MODE.get())).equals((Object)ConfigEnums.ZoomModes.PERSISTENT) && !ZoomKeyBinds.ZOOM_KEY.m_90857_()) {
                return;
            }
            if (event.getScrollDelta() != 0.0 && ZoomUtils.ZOOMER_ZOOM.getZoom()) {
                ZoomUtils.changeZoomDivisor(event.getScrollDelta() > 0.0);
                event.setCanceled(true);
            }
        }
    }

    public static void sendToast(Component description) {
        if (((Boolean)ClientConfig.SHOW_RESTRICTION_TOASTS.get()).booleanValue()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)TOAST_TITLE, (Component)description));
        }
    }

    static {
        OVERLAY_NAME = new ResourceLocation("okzoomer", "okzoomer");
        TOAST_TITLE = Component.m_237115_((String)"toast.okzoomer.title");
    }
}

