/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.network;

import com.matyrobbrt.okzoomer.api.MouseModifier;
import com.matyrobbrt.okzoomer.api.modifiers.CinematicCameraMouseModifier;
import com.matyrobbrt.okzoomer.api.modifiers.ContainingMouseModifier;
import com.matyrobbrt.okzoomer.api.modifiers.ZoomDivisorMouseModifier;
import com.matyrobbrt.okzoomer.api.overlays.SpyglassZoomOverlay;
import com.matyrobbrt.okzoomer.api.transitions.InstantTransitionMode;
import com.matyrobbrt.okzoomer.api.transitions.SmoothTransitionMode;
import com.matyrobbrt.okzoomer.config.ClientConfig;
import com.matyrobbrt.okzoomer.config.ConfigEnums;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import com.matyrobbrt.okzoomer.zoom.LinearTransitionMode;
import com.matyrobbrt.okzoomer.zoom.MultipliedCinematicCameraMouseModifier;
import com.matyrobbrt.okzoomer.zoom.ZoomerZoomOverlay;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.network.simple.SimpleChannel;

public class OkZoomerNetwork {
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("okzoomer", "network")).clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).networkProtocolVersion(() -> "hmm :)").simpleChannel();
    public static final EventNetworkChannel EXISTENCE_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("okzoomer", "exists")).clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).networkProtocolVersion(() -> "Why'd I exist?!").eventNetworkChannel();
    public static boolean hasRestrictions = false;
    public static boolean disableZoom = false;
    public static boolean disableZoomScrolling = false;
    public static boolean forceClassicMode = false;
    public static boolean forceZoomDivisors = false;
    public static Acknowledgement acknowledgement = Acknowledgement.NONE;
    public static double maximumZoomDivisor = 0.0;
    public static double minimumZoomDivisor = 0.0;
    public static ConfigEnums.SpyglassDependency spyglassDependency = null;
    public static ConfigEnums.ZoomOverlays spyglassOverlay = ConfigEnums.ZoomOverlays.OFF;

    public static boolean getHasRestrictions() {
        return hasRestrictions;
    }

    public static Acknowledgement checkRestrictions() {
        boolean hasRestrictions = disableZoom || disableZoomScrolling || forceClassicMode || forceZoomDivisors || spyglassDependency != null || spyglassOverlay != ConfigEnums.ZoomOverlays.OFF;
        acknowledgement = hasRestrictions ? Acknowledgement.HAS_RESTRICTIONS : Acknowledgement.HAS_NO_RESTRICTIONS;
        return acknowledgement;
    }

    public static boolean getDisableZoom() {
        return disableZoom;
    }

    public static boolean getDisableZoomScrolling() {
        return disableZoomScrolling;
    }

    public static boolean getForceClassicMode() {
        return forceClassicMode;
    }

    public static boolean getForceZoomDivisors() {
        return forceZoomDivisors;
    }

    public static Acknowledgement getAcknowledgement() {
        return acknowledgement;
    }

    public static double getMaximumZoomDivisor() {
        return maximumZoomDivisor;
    }

    public static double getMinimumZoomDivisor() {
        return minimumZoomDivisor;
    }

    public static ConfigEnums.SpyglassDependency getSpyglassDependency() {
        return spyglassDependency != null ? spyglassDependency : (ConfigEnums.SpyglassDependency)((Object)ClientConfig.SPYGLASS_DEPENDENCY.get());
    }

    public static ConfigEnums.ZoomOverlays getSpyglassOverlay() {
        return spyglassOverlay;
    }

    public static void resetRestrictions() {
        hasRestrictions = false;
        disableZoom = false;
        disableZoomScrolling = false;
        forceZoomDivisors = false;
        acknowledgement = Acknowledgement.NONE;
        maximumZoomDivisor = 0.0;
        minimumZoomDivisor = 0.0;
        spyglassDependency = null;
        if (forceClassicMode || spyglassOverlay != ConfigEnums.ZoomOverlays.OFF) {
            forceClassicMode = false;
            spyglassOverlay = ConfigEnums.ZoomOverlays.OFF;
            OkZoomerNetwork.configureZoomInstance();
        }
    }

    public static void configureZoomInstance() {
        ZoomUtils.ZOOMER_ZOOM.setTransitionMode(switch ((ConfigEnums.ZoomTransitionOptions)((Object)ClientConfig.ZOOM_TRANSITION.get())) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode((float)((Double)ClientConfig.SMOOTH_MULTIPLIER.get()).doubleValue());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode((Double)ClientConfig.MINIMUM_LINEAR_STEP.get(), (Double)ClientConfig.MAXIMUM_LINEAR_STEP.get());
            default -> new InstantTransitionMode();
        });
        if (OkZoomerNetwork.getForceClassicMode()) {
            ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor(4.0);
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier(new CinematicCameraMouseModifier());
            ZoomUtils.ZOOMER_ZOOM.setZoomOverlay(null);
            return;
        }
        ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor((Double)ClientConfig.ZOOM_DIVISOR.get());
        OkZoomerNetwork.configureZoomModifier();
        ConfigEnums.ZoomOverlays overlay = spyglassOverlay == ConfigEnums.ZoomOverlays.OFF ? (ConfigEnums.ZoomOverlays)((Object)ClientConfig.ZOOM_OVERLAY.get()) : spyglassOverlay;
        ResourceLocation overlayTextureId = new ResourceLocation((Boolean)ClientConfig.USE_SPYGLASS_TEXTURE.get() != false || overlay == ConfigEnums.ZoomOverlays.SPYGLASS ? "textures/misc/spyglass_scope.png" : "okzoomer:textures/misc/zoom_overlay.png");
        ZoomUtils.ZOOMER_ZOOM.setZoomOverlay(switch (overlay) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        });
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = (ConfigEnums.CinematicCameraOptions)((Object)ClientConfig.CINEMATIC_CAMERA.get());
        boolean reduceSensitivity = (Boolean)ClientConfig.REDUCE_SENSITIVITY.get();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            MouseModifier cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier((Double)ClientConfig.CINEMATIC_MULTIPLIER.get());
                default -> null;
            };
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier(reduceSensitivity ? new ContainingMouseModifier(new ZoomDivisorMouseModifier(), cinematicModifier) : cinematicModifier);
        } else {
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier(reduceSensitivity ? new ZoomDivisorMouseModifier() : null);
        }
    }

    public static enum Acknowledgement {
        NONE,
        HAS_RESTRICTIONS,
        HAS_NO_RESTRICTIONS;

    }
}

