/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.network.packet;

import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import com.matyrobbrt.okzoomer.network.packet.Packet;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ForceClassicModePacket(boolean forceClassicMode) implements Packet
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forceClassicMode);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        OkZoomerNetwork.disableZoomScrolling = this.forceClassicMode;
        OkZoomerNetwork.forceClassicMode = this.forceClassicMode;
        OkZoomerNetwork.configureZoomInstance();
        OkZoomerNetwork.checkRestrictions();
        if (this.forceClassicMode) {
            ZoomUtils.LOGGER.info("This server has imposed classic mode");
        }
    }

    public static ForceClassicModePacket decode(FriendlyByteBuf buf) {
        return new ForceClassicModePacket(buf.readBoolean());
    }
}

