/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.zoom;

import com.matyrobbrt.okzoomer.api.MouseModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.SmoothDouble;

public class MultipliedCinematicCameraMouseModifier
implements MouseModifier {
    private static final ResourceLocation MODIFIER_ID = new ResourceLocation("okzoomer", "multiplied_cinematic_camera");
    private boolean active;
    private final Minecraft client;
    private boolean cinematicCameraEnabled;
    private final SmoothDouble cursorXZoomSmoother = new SmoothDouble();
    private final SmoothDouble cursorYZoomSmoother = new SmoothDouble();
    private double cinematicCameraMultiplier;

    public MultipliedCinematicCameraMouseModifier(double cinematicCameraMultiplier) {
        this.cinematicCameraMultiplier = cinematicCameraMultiplier;
        this.client = Minecraft.m_91087_();
    }

    @Override
    public ResourceLocation getId() {
        return MODIFIER_ID;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyXModifier(double cursorDeltaX, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        if (this.cinematicCameraEnabled) {
            this.cursorXZoomSmoother.m_14236_();
            return cursorDeltaX;
        }
        double smoother = mouseUpdateTimeDelta * this.cinematicCameraMultiplier * cursorSensitivity;
        return this.cursorXZoomSmoother.m_14237_(cursorDeltaX, smoother);
    }

    @Override
    public double applyYModifier(double cursorDeltaY, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        if (this.cinematicCameraEnabled) {
            this.cursorYZoomSmoother.m_14236_();
            return cursorDeltaY;
        }
        double smoother = mouseUpdateTimeDelta * this.cinematicCameraMultiplier * cursorSensitivity;
        return this.cursorYZoomSmoother.m_14237_(cursorDeltaY, smoother);
    }

    @Override
    public void tick(boolean active) {
        this.cinematicCameraEnabled = this.client.f_91066_.f_92067_;
        if (!active && active != this.active) {
            this.cursorXZoomSmoother.m_14236_();
            this.cursorYZoomSmoother.m_14236_();
        }
        this.active = active;
    }
}

