/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import pro.komaru.tridot.client.tooltip.TooltipModifierHandler;
import ru.auriny.omegablacksmith.client.screen.BlacksmithScreen;
import ru.auriny.omegablacksmith.core.network.NetMessages;
import ru.auriny.omegablacksmith.core.registries.AttributeRegistry;
import ru.auriny.omegablacksmith.core.registries.CreativeTabRegistry;
import ru.auriny.omegablacksmith.core.registries.ItemRegistry;
import ru.auriny.omegablacksmith.core.registries.MenuRegistry;
import ru.auriny.omegablacksmith.server.task.MultiplierDecayTask;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@Mod(value="omegablacksmith")
public class OmegaBlacksmith {
    public static final String MODID = "omegablacksmith";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final UUID BASE_DURABILITY_UUID = UUID.fromString("b65ca8f4-29fe-44a2-83fe-c6f1799d5c7f");
    public static final UUID BASE_DURABILITY_UUID_BLUE = UUID.fromString("b65ca8f4-29fe-44a2-83fe-c6f1799d5c7d");

    public OmegaBlacksmith() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MenuRegistry.register(modEventBus);
        NetMessages.register();
        ItemRegistry.ITEMS.register(modEventBus);
        AttributeRegistry.register(modEventBus);
        CreativeTabRegistry.TAB.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @GradleSideOnly(value={GradleSide.SERVER})
    public void onServerStarting(ServerStartingEvent event) {
        MultiplierDecayTask.start();
    }

    @Mod.EventBusSubscriber(modid="omegablacksmith", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    @GradleSideOnly(value={GradleSide.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        @GradleSideOnly(value={GradleSide.CLIENT})
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                LOGGER.info("{} >> client-setup", (Object)OmegaBlacksmith.MODID);
                MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.OMEGA_BLACKSMITH_MENU.get()), BlacksmithScreen::new);
                TooltipModifierHandler.add((UUID)BASE_DURABILITY_UUID);
            });
        }
    }
}

