/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.client.screen;

import com.idark.valoria.Valoria;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.render.text.DotStyleEffects;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;
import ru.auriny.omegablacksmith.client.screen.HammerButton;
import ru.auriny.omegablacksmith.core.menu.BlacksmithMenu;
import ru.auriny.omegablacksmith.core.network.GetMoneyQueryPacket;
import ru.auriny.omegablacksmith.core.network.GetMultiplierQueryPacket;
import ru.auriny.omegablacksmith.core.network.NetMessages;
import ru.auriny.omegablacksmith.core.reforge.ReforgeRegistry;
import ru.auriny.omegablacksmith.core.reforge.ReforgeType;
import ru.auriny.omegablacksmith.core.util.RomanNumerals;

public class BlacksmithScreen
extends AbstractContainerScreen<BlacksmithMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("omegablacksmith", "textures/gui/blacksmith.png");
    private static final int TOOLTIP_BG_COLOR = -1879048192;
    private static final int TOOLTIP_BORDER_COLOR = -1;
    private static final int MAX_LAYERS = 6;
    private static final int TOTAL_TIME = 2000;
    private static final int STAY_TIME = 1200;
    private static final int RISE_TIME = 800;
    private static final int MOVE_DISTANCE = 18;
    private static final int SPACING = 10;
    private static final float MIN_ALPHA = 0.05f;
    private final List<ReforgeDisplay> messages = new ArrayList<ReforgeDisplay>();
    private double money;
    private String symbol = "\u2662";
    private boolean moneySynced = false;
    private float multiplier;

    public BlacksmithScreen(BlacksmithMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97728_ = 10;
        this.f_97729_ = 10;
        this.f_97730_ = 10;
        this.f_97731_ = 87;
        NetMessages.CHANNEL.sendToServer((Object)new GetMoneyQueryPacket());
        NetMessages.CHANNEL.sendToServer((Object)new GetMultiplierQueryPacket());
    }

    public void syncMoney(double money, String symbol) {
        this.money = money;
        this.symbol = symbol;
        this.moneySynced = true;
    }

    public void syncMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void showReforgeText(String reforgeId, int level) {
        ReforgeRegistry.get(reforgeId).ifPresent(reforge -> {
            String levelRoman = RomanNumerals.toRoman(level);
            Col color = switch (reforge.getCategory()) {
                default -> throw new IncompatibleClassChangeError();
                case ReforgeType.Category.POSITIVE -> Col.green;
                case ReforgeType.Category.NEUTRAL -> Col.lightGray;
                case ReforgeType.Category.NEGATIVE -> Col.red;
            };
            MutableComponent text = Component.m_237113_((String)(reforge.getDisplayName() + " " + levelRoman)).m_130948_((Style)DotStyle.of().color(color.darker().darker().darker()).effect((DotStyle.StyleEffect)DotStyleEffects.OutlineFX.of((Col)color.brighter().brighter().brighter(), (boolean)true)));
            for (int i = 0; i < this.messages.size(); ++i) {
                ReforgeDisplay old = this.messages.get(i);
                this.messages.set(i, new ReforgeDisplay(old.text(), old.level(), old.color(), old.startTime(), old.targetYOffset() + 10.0f, old.targetYOffset() + 10.0f));
            }
            this.messages.add(new ReforgeDisplay((Component)text, level, color, System.currentTimeMillis(), 10.0f, 0.0f));
            if (this.messages.size() > 6) {
                this.messages.remove(0);
            }
        });
    }

    private void handleHammerPress() {
        boolean hasCore;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean hasItem = !((BlacksmithMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_();
        boolean bl = hasCore = !((BlacksmithMenu)this.f_97732_).m_38853_(1).m_7993_().m_41619_();
        if (!hasItem) {
            player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.1f);
            return;
        }
        if (!hasCore && this.money < (double)((BlacksmithMenu)this.f_97732_).costMul(this.multiplier)) {
            player.m_5496_(SoundEvents.f_12507_, 1.0f, 1.1f);
            return;
        }
        player.m_5496_(SoundEvents.f_11671_, 1.0f, 1.1f + player.m_9236_().f_46441_.m_188501_() * 0.1f);
    }

    private void renderReforgeTexts(GuiGraphics gfx, int mouseX, int mouseY) {
        long now = System.currentTimeMillis();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        List<ReforgeDisplay> currentMessages = List.copyOf(this.messages);
        int rendered = 0;
        for (ReforgeDisplay display : currentMessages) {
            float alpha;
            float alphaCheck;
            long elapsed = now - display.startTime();
            if (elapsed >= 2000L && (alphaCheck = 1.0f - (float)elapsed / 2000.0f) <= 0.05f) {
                this.messages.remove(display);
                continue;
            }
            float progress = Math.min((float)elapsed / 2000.0f, 1.0f);
            float scale = progress < 0.2f ? this.lerp(0.5f, 1.0f, progress / 0.2f) : 1.0f;
            float fadeOutStart = 0.7f;
            if (progress >= fadeOutStart) {
                float fadeProgress = (progress - fadeOutStart) / 0.3f;
                alpha = 1.0f - fadeProgress;
                scale = this.lerp(1.0f, 0.7f, fadeProgress);
            } else {
                alpha = 1.0f;
            }
            alpha = Math.max(alpha, 0.0f);
            int alphaInt = (int)(alpha * 255.0f);
            if (alphaInt < 12) {
                alphaInt = 0;
            }
            if (alphaInt == 0) {
                this.messages.remove(display);
                continue;
            }
            int moveY = 0;
            if (elapsed > 1200L) {
                float riseProgress = (float)(elapsed - 1200L) / 800.0f;
                riseProgress = Math.min(riseProgress, 1.0f);
                moveY = (int)(riseProgress * 18.0f);
            }
            float smoothing = 0.15f;
            float newYOffset = this.lerp(display.currentYOffset(), display.targetYOffset(), smoothing);
            int idx = this.messages.indexOf(display);
            if (idx != -1) {
                ReforgeDisplay md = this.messages.get(idx);
                this.messages.set(idx, new ReforgeDisplay(md.text(), md.level(), md.color(), md.startTime(), newYOffset, md.targetYOffset()));
            }
            int yOffset = -moveY - (int)newYOffset;
            int baseColor = new Color(display.color.r, display.color.g, display.color.b, display.color.a).getRGB();
            int r = baseColor >> 16 & 0xFF;
            int g = baseColor >> 8 & 0xFF;
            int b = baseColor & 0xFF;
            int color = alphaInt << 24 | r << 16 | g << 8 | b;
            gfx.m_280168_().m_85836_();
            int x = mouseX + 10;
            int y = mouseY - 10 + yOffset;
            gfx.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            float rotation = (float)Math.sin((double)elapsed * 0.005 + (double)rendered) * 1.33f;
            gfx.m_280168_().m_252781_(Axis.f_252403_.m_252977_(rotation));
            float scaledWidth = (float)this.f_96547_.m_92852_((FormattedText)display.text()) * scale;
            gfx.m_280168_().m_85841_(scale, scale, 1.0f);
            gfx.m_280168_().m_252880_(-scaledWidth / scale / 2.0f, 0.0f, 0.0f);
            gfx.m_280614_(this.f_96547_, display.text(), 0, 0, color, false);
            gfx.m_280168_().m_85849_();
            ++rendered;
        }
        RenderSystem.disableBlend();
    }

    private float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    protected void m_7856_() {
        super.m_7856_();
        int hx = this.f_97735_ + 68;
        int hy = this.f_97736_ + 52;
        ((HammerButton)this.m_142416_((GuiEventListener)new HammerButton(hx, hy, this::handleHammerPress))).m_257544_(Tooltip.m_257550_((Component)this.getReforgeTooltip()));
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof HammerButton)) continue;
            HammerButton hammer = (HammerButton)widget;
            hammer.m_257544_(Tooltip.m_257550_((Component)this.getReforgeTooltip()));
        }
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderCustomTooltip(guiGraphics);
        this.renderReforgeTexts(guiGraphics, mouseX, mouseY);
    }

    private Component getReforgeTooltip() {
        ItemStack itemSlot = ((BlacksmithMenu)this.f_97732_).m_38853_(0).m_7993_();
        ItemStack coreSlot = ((BlacksmithMenu)this.f_97732_).m_38853_(1).m_7993_();
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)"\u2692 ").m_7220_((Component)Component.m_237113_((String)"\u041f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0430").m_130940_(ChatFormatting.GOLD)));
        lines.add((Component)Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u2144 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0438").m_130938_(style -> style.m_131150_(Valoria.FONT).m_131140_(ChatFormatting.GRAY)));
        lines.add((Component)Component.m_237113_((String)""));
        if (itemSlot.m_41619_()) {
            lines.add((Component)Component.m_237113_((String)"\u2716 \u041f\u043e\u043b\u043e\u0436\u0438\u0442\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0438").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        } else if (coreSlot.m_41619_()) {
            lines.add((Component)Component.m_237113_((String)"\u26a0 \u0411\u0435\u0437 \u044f\u0434\u0440\u0430 \u043f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e\u0439 \u0438 \u043f\u043b\u0430\u0442\u043d\u043e\u0439").m_130940_(ChatFormatting.YELLOW));
            lines.add((Component)Component.m_237113_((String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c: ").m_7220_((Component)Component.m_237113_((String)(this.symbol + " " + new DecimalFormat("#,##0.00").format(((BlacksmithMenu)this.f_97732_).costMul(this.multiplier)))).m_130940_(this.money >= (double)((BlacksmithMenu)this.f_97732_).costMul(this.multiplier) ? ChatFormatting.GREEN : ChatFormatting.RED)));
        } else {
            lines.add((Component)Component.m_237113_((String)"\u2714 \u041f\u0435\u0440\u0435\u043a\u043e\u0432\u043a\u0430 \u0441 \u044f\u0434\u0440\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0439").m_130940_(ChatFormatting.GREEN));
        }
        return BlacksmithScreen.joinLines(lines);
    }

    public static Component joinLines(List<Component> lines) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < lines.size(); ++i) {
            result.m_7220_(lines.get(i));
            if (i >= lines.size() - 1) continue;
            result.m_130946_("\n");
        }
        return result;
    }

    private void renderCustomTooltip(@NotNull GuiGraphics guiGraphics) {
        int tx = this.f_97735_ + 7;
        int ty = this.f_97736_ + 7;
        int tw = 162;
        int th = 38;
        guiGraphics.m_280509_(tx, ty, tx + tw, ty + th, -1879048192);
        guiGraphics.m_280509_(tx, ty, tx + tw, ty + 1, -1);
        guiGraphics.m_280509_(tx, ty, tx + 1, ty + th, -1);
        guiGraphics.m_280509_(tx, ty + th - 1, tx + tw, ty + th, -1);
        guiGraphics.m_280509_(tx + tw - 1, ty, tx + tw, ty + th, -1);
        int x = tx + 4;
        int y = ty + 4;
        ChatFormatting mulCol = ChatFormatting.GRAY;
        if ((double)this.multiplier < 1.2) {
            mulCol = ChatFormatting.GREEN;
        }
        if ((double)this.multiplier >= 1.2 && (double)this.multiplier <= 1.65) {
            mulCol = ChatFormatting.YELLOW;
        } else if ((double)this.multiplier > 1.65) {
            mulCol = ChatFormatting.RED;
        }
        float multiplierRound = (float)Math.round(this.multiplier * 100.0f) / 100.0f;
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u041c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438: ").m_7220_((Component)Component.m_237113_((String)("x" + multiplierRound)).m_130940_(mulCol)), x, y, 0xFFFFFF);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (!((BlacksmithMenu)this.f_97732_).container.m_8020_(0).m_41619_()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 18, this.f_97736_ + 51, 176, 0, 16, 16);
        }
        if (!((BlacksmithMenu)this.f_97732_).container.m_8020_(1).m_41619_()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 43, this.f_97736_ + 51, 176, 0, 16, 16);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String moneyStr = new DecimalFormat(this.symbol + " #,##0.00").format(this.money);
        MutableComponent moneyText = Component.m_237113_((String)moneyStr);
        int maxWidth = 56;
        int startX = 101;
        int y = 57;
        if (!this.moneySynced) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"..."), startX, y, 0xAAAAAA);
            return;
        }
        int textWidth = this.f_96547_.m_92852_((FormattedText)moneyText);
        int rectX = this.f_97735_ + startX;
        int rectY = this.f_97736_ + y;
        int rectW = maxWidth;
        Objects.requireNonNull(this.f_96547_);
        int rectH = 9;
        guiGraphics.m_280588_(rectX, rectY, rectX + rectW, rectY + rectH);
        if (textWidth > maxWidth) {
            double time = (double)(System.currentTimeMillis() % 10000L) / 10000.0;
            double factor = time < 0.16666666666666666 ? time / 0.16666666666666666 : (time < 0.5 ? 1.0 : (time < 0.666 ? 1.0 - (time - 0.5) / 0.16666666666666666 : 0.0));
            int fieldLeft = startX;
            int fieldRight = startX + maxWidth;
            int minX = fieldRight - textWidth;
            int x = (int)((double)minX + (double)(fieldLeft - minX) * factor);
            guiGraphics.m_280430_(this.f_96547_, (Component)moneyText, x, y, 0x55FF55);
        } else {
            guiGraphics.m_280430_(this.f_96547_, (Component)moneyText, startX, y, 0x55FF55);
        }
        guiGraphics.m_280618_();
    }

    private record ReforgeDisplay(Component text, int level, Col color, long startTime, float currentYOffset, float targetYOffset) {
    }
}

