/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.core.event;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import ru.auriny.omegablacksmith.OmegaBlacksmith;
import ru.auriny.omegablacksmith.core.capability.ReforgeMultiplierProvider;
import ru.auriny.omegablacksmith.core.reforge.ReforgeRegistry;
import ru.auriny.omegablacksmith.core.reforge.dto.AttributeModifierData;
import ru.auriny.omegablacksmith.core.registries.AttributeRegistry;
import ru.auriny.omegablacksmith.core.registries.CapabilityRegistry;
import ru.auriny.omegablacksmith.core.util.RomanNumerals;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@Mod.EventBusSubscriber(modid="omegablacksmith", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReforgeEvents {
    @SubscribeEvent
    public static void onItemAttributeModifiers(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || !stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("ReforgeId") || !tag.m_128441_("ReforgeLevel")) {
            return;
        }
        String reforgeId = tag.m_128461_("ReforgeId");
        int level = tag.m_128451_("ReforgeLevel");
        ReforgeRegistry.get(reforgeId).ifPresent(reforge -> {
            for (AttributeModifierData data : reforge.getModifiers(level)) {
                if (event.getSlotType() != EquipmentSlot.MAINHAND) continue;
                event.addModifier(data.getAttribute(), data.toMinecraftModifier());
            }
        });
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.CLIENT})
    public static void onTooltipGatherComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || !stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("ReforgeId") || !tag.m_128441_("ReforgeLevel")) {
            return;
        }
        String reforgeId = tag.m_128461_("ReforgeId");
        int level = tag.m_128451_("ReforgeLevel");
        ReforgeRegistry.get(reforgeId).ifPresent(reforge -> {
            List elements = event.getTooltipElements();
            int insertIndex = 1;
            ChatFormatting color = ChatFormatting.DARK_GRAY;
            switch (reforge.getCategory()) {
                case POSITIVE: {
                    color = ChatFormatting.GREEN;
                    break;
                }
                case NEUTRAL: {
                    color = ChatFormatting.GRAY;
                    break;
                }
                case NEGATIVE: {
                    color = ChatFormatting.RED;
                }
            }
            elements.add(insertIndex++, Either.right((Object)new SeparatorComponent((Component)Component.m_237113_((String)("\u2692 " + reforge.getDisplayName() + " " + RomanNumerals.toRoman(level) + " \u2692")).m_130940_(color))));
            for (AttributeModifierData data : reforge.getModifiers(level)) {
                String sign = data.amount() >= 0.0 ? "+" : "";
                String value = data.operation() == AttributeModifier.Operation.MULTIPLY_BASE ? (int)(data.amount() * 100.0) + "%" : String.valueOf(data.amount());
                ChatFormatting modifierColor = data.amount() >= 0.0 ? ChatFormatting.BLUE : ChatFormatting.RED;
                elements.add(insertIndex++, Either.right((Object)new TextComponent(Component.m_237113_((String)("  " + sign + value + " ")).m_7220_((Component)Component.m_237115_((String)data.getAttribute().m_22087_())).m_130940_(modifierColor))));
            }
        });
    }

    @SubscribeEvent
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || !stack.m_41763_()) {
            return;
        }
        int max = stack.m_41776_();
        UUID uuid = switch (event.getSlotType()) {
            case EquipmentSlot.MAINHAND -> OmegaBlacksmith.BASE_DURABILITY_UUID;
            default -> OmegaBlacksmith.BASE_DURABILITY_UUID_BLUE;
        };
        event.addModifier((Attribute)AttributeRegistry.DURABILITY.get(), new AttributeModifier(uuid, "Base durability", (double)max, AttributeModifier.Operation.ADDITION));
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.SERVER})
    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayer) {
            event.addCapability(new ResourceLocation("omegablacksmith", "reforge_multiplier"), (ICapabilityProvider)new ReforgeMultiplierProvider());
        }
    }

    @SubscribeEvent
    @GradleSideOnly(value={GradleSide.SERVER})
    public static void onClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(CapabilityRegistry.REFORGE_MULTIPLIER_CAPABILITY).ifPresent(oldCap -> event.getOriginal().getCapability(CapabilityRegistry.REFORGE_MULTIPLIER_CAPABILITY).ifPresent(newCap -> newCap.setMultiplier(oldCap.getMultiplier())));
    }
}

