/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegablacksmith.core.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.omegablacksmith.client.screen.BlacksmithScreen;
import ru.justagod.cutter.invoke.Invoke;

public class GetMoneyPacket {
    private final double money;
    private final String symbol;

    public GetMoneyPacket(double money, String symbol) {
        this.money = money;
        this.symbol = symbol;
    }

    public GetMoneyPacket() {
        this.money = 0.0;
        this.symbol = "";
    }

    public double getMoney() {
        return this.money;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static void encode(GetMoneyPacket pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.money);
        buf.m_130072_(pkt.symbol != null ? pkt.symbol : "", Short.MAX_VALUE);
    }

    public static GetMoneyPacket decode(FriendlyByteBuf buf) {
        double money = buf.readDouble();
        String symbol = buf.m_130136_(Short.MAX_VALUE);
        return new GetMoneyPacket(money, symbol);
    }

    public static void handle(GetMoneyPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Invoke.client(() -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt1554$temp = mc.f_91080_;
            if (patt1554$temp instanceof BlacksmithScreen) {
                BlacksmithScreen screen = (BlacksmithScreen)patt1554$temp;
                screen.syncMoney(pkt.money, pkt.symbol);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public static GetMoneyPacket of(double money, String symbol) {
        return new GetMoneyPacket(money, symbol);
    }
}

